/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.dto.method.JavaCGMethodInfo;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEDYNAMIC;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;

public class JavaCGInstructionUtil {
    public static boolean isMethodInvokeInstruction(short opCode) {
        return opCode >= 182 && opCode <= 186;
    }

    public static boolean isMethodInvokeInstructionExcludeDynamic(short opCode) {
        return opCode >= 182 && opCode <= 185;
    }

    public static boolean isIfInstruction(int opCode) {
        return opCode >= 153 && opCode <= 166 || opCode == 198 || opCode == 199;
    }

    public static boolean isSwitchInstruction(int opCode) {
        return opCode == 170 || opCode == 171;
    }

    public static boolean isGotoInstruction(int opCode) {
        return opCode == 167 || opCode == 200;
    }

    public static boolean isExitInstruction(int opCode) {
        return opCode >= 172 && opCode <= 177 || opCode == 191;
    }

    public static boolean isJsrInstruction(int opCode) {
        return opCode == 168 || opCode == 201;
    }

    public static boolean isRetInstruction(int opCode) {
        return opCode == 169;
    }

    public static boolean isReturnWithValueInstruction(int opCode) {
        return opCode >= 172 && opCode <= 176;
    }

    public static String getInstructionHandlePrintInfo(InstructionHandle ih) {
        Instruction instruction = ih.getInstruction();
        String extra = "";
        if (instruction instanceof IndexedInstruction) {
            extra = " " + ((IndexedInstruction)instruction).getIndex();
        } else if (instruction instanceof BranchInstruction) {
            extra = " " + ((BranchInstruction)instruction).getTarget().getPosition();
        }
        return "[" + ih.getPosition() + "] " + instruction.getClass().getSimpleName() + extra;
    }

    public static InstructionHandle getFirstInstructionHandle(MethodGen mg) {
        InstructionList instructionList = mg.getInstructionList();
        if (instructionList == null || instructionList.isEmpty()) {
            return null;
        }
        return instructionList.getStart();
    }

    public static JavaCGMethodInfo getCalleeMethodInfo(InvokeInstruction invokeInstruction, ConstantPoolGen cpg) {
        String calleeMethodName = invokeInstruction.getMethodName(cpg);
        Type[] calleeArgTypes = invokeInstruction.getArgumentTypes(cpg);
        if (invokeInstruction instanceof INVOKEDYNAMIC) {
            String calleeClassName = invokeInstruction.getType(cpg).toString();
            return new JavaCGMethodInfo(calleeClassName, calleeMethodName, calleeArgTypes, invokeInstruction.getReturnType(cpg));
        }
        String calleeClassName = invokeInstruction.getReferenceType(cpg).toString();
        return new JavaCGMethodInfo(calleeClassName, calleeMethodName, calleeArgTypes, invokeInstruction.getReturnType(cpg));
    }

    private JavaCGInstructionUtil() {
        throw new IllegalStateException("illegal");
    }
}

