/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.common.TypeConstants;
import com.adrninistrator.javacg.common.enums.JavaCGConstantTypeEnum;
import com.adrninistrator.javacg.dto.classes.InnerClassInfo;
import com.adrninistrator.javacg.dto.method.MethodArgReturnTypes;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Signature;
import org.apache.bcel.classfile.Utility;
import org.apache.commons.lang3.StringUtils;

public class JavaCGByteCodeUtil {
    public static boolean checkExtendsMethod(String methodName, AccessFlags accessFlags) {
        return !methodName.startsWith("<") && !accessFlags.isStatic() && (accessFlags.isAbstract() || accessFlags.isPublic() || accessFlags.isProtected() || !accessFlags.isPrivate());
    }

    public static boolean checkImplMethod(String methodName, AccessFlags accessFlags) {
        return !methodName.startsWith("<") && !accessFlags.isStatic() && !accessFlags.isAbstract() && accessFlags.isPublic();
    }

    public static List<MethodArgReturnTypes> genImplClassMethodWithArgs(Method[] methods) {
        ArrayList<MethodArgReturnTypes> methodInfoList = new ArrayList<MethodArgReturnTypes>(methods.length);
        for (Method method : methods) {
            String methodName = method.getName();
            if (!JavaCGByteCodeUtil.checkImplMethod(methodName, (AccessFlags)method)) continue;
            methodInfoList.add(new MethodArgReturnTypes(methodName, method.getArgumentTypes(), method.getReturnType()));
        }
        return methodInfoList;
    }

    public static List<MethodArgReturnTypes> genInterfaceMethodWithArgs(Method[] methods) {
        ArrayList<MethodArgReturnTypes> methodInfoList = new ArrayList<MethodArgReturnTypes>(methods.length);
        for (Method method : methods) {
            methodInfoList.add(new MethodArgReturnTypes(method.getName(), method.getArgumentTypes(), method.getReturnType()));
        }
        return methodInfoList;
    }

    public static int getFuncStartSourceLine(Method method) {
        LineNumberTable lineNumberTable = method.getLineNumberTable();
        if (lineNumberTable == null || lineNumberTable.getLineNumberTable() == null) {
            return 0;
        }
        return lineNumberTable.getLineNumberTable()[0].getLineNumber();
    }

    private static int getInitFuncStartSourceLine(JavaClass javaClass) {
        Method[] methods = javaClass.getMethods();
        if (methods == null) {
            return 0;
        }
        for (Method method : methods) {
            if (!JavaCGUtil.isInitMethod(method.getName())) continue;
            return JavaCGByteCodeUtil.getFuncStartSourceLine(method);
        }
        return 0;
    }

    public static String removeArrayInClassName(String className) {
        if (!className.startsWith("[")) {
            return className;
        }
        String tmpClassName = Utility.typeSignatureToString((String)className, (boolean)false);
        return JavaCGByteCodeUtil.removeArrayFlag(tmpClassName);
    }

    public static String addArrayFlag(String className) {
        return className + "[]";
    }

    public static String removeArrayFlag(String arrayType) {
        if (arrayType == null) {
            return null;
        }
        if (!JavaCGByteCodeUtil.isArrayType(arrayType) && !JavaCGByteCodeUtil.isNullType(arrayType)) {
            System.err.println("\u7c7b\u540d\u4e0d\u662f\u6570\u7ec4\u5f62\u5f0f " + arrayType);
            return arrayType;
        }
        return arrayType.substring(0, arrayType.length() - "[]".length());
    }

    public static boolean isArrayType(String type) {
        return type.endsWith("[]");
    }

    public static int getTypeSize(String typeString) {
        if (JavaCGConstantTypeEnum.CONSTTE_DOUBLE.getType().equals(typeString) || JavaCGConstantTypeEnum.CONSTTE_LONG.getType().equals(typeString)) {
            return 2;
        }
        return 1;
    }

    public static boolean checkCompatibleWithInt(String type) {
        for (String compatibleType : TypeConstants.COMPATIBLE_INT_TYPES) {
            if (!compatibleType.equals(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullType(String type) {
        return type == null || JavaCGConstantTypeEnum.CONSTTE_NULL.getType().equals(type);
    }

    public static boolean compareType(String type1, String type2) {
        if (type1.equals(type2)) {
            return true;
        }
        if (JavaCGByteCodeUtil.compareIntType(type1, type2)) {
            return true;
        }
        return JavaCGByteCodeUtil.compareByteBooleanType(type1, type2);
    }

    public static boolean compareIntType(String type1, String type2) {
        if (JavaCGConstantTypeEnum.CONSTTE_INT.getType().equals(type1) && JavaCGByteCodeUtil.checkCompatibleWithInt(type2)) {
            return true;
        }
        return JavaCGConstantTypeEnum.CONSTTE_INT.getType().equals(type2) && JavaCGByteCodeUtil.checkCompatibleWithInt(type1);
    }

    public static boolean compareByteBooleanType(String type1, String type2) {
        if (JavaCGConstantTypeEnum.CONSTTE_BYTE.getType().equals(type1) && JavaCGConstantTypeEnum.CONSTTE_BOOLEAN.getType().equals(type2)) {
            return true;
        }
        if (JavaCGConstantTypeEnum.CONSTTE_BYTE.getType().equals(type2) && JavaCGConstantTypeEnum.CONSTTE_BOOLEAN.getType().equals(type1)) {
            return true;
        }
        if (TypeConstants.BYTE_ARRAY_TYPE.equals(type1) && TypeConstants.BOOLEAN_ARRAY_TYPE.equals(type2)) {
            return true;
        }
        return TypeConstants.BYTE_ARRAY_TYPE.equals(type2) && TypeConstants.BOOLEAN_ARRAY_TYPE.equals(type1);
    }

    public static boolean isPublicFlag(int accessFlags) {
        return (accessFlags & 1) != 0;
    }

    public static boolean isProtectedMethod(int accessFlags) {
        return (accessFlags & 4) != 0;
    }

    public static boolean isPrivateMethod(int accessFlags) {
        return (accessFlags & 2) != 0;
    }

    public static boolean isAbstractFlag(int accessFlags) {
        return (accessFlags & 0x400) != 0;
    }

    public static boolean isBridgeFlag(int accessFlags) {
        return (accessFlags & 0x40) != 0;
    }

    public static int setPublicFlag(int accessFlags, boolean trueOrFalse) {
        return JavaCGByteCodeUtil.setFlag(accessFlags, 1, trueOrFalse);
    }

    public static int setProtectedFlag(int accessFlags, boolean trueOrFalse) {
        return JavaCGByteCodeUtil.setFlag(accessFlags, 4, trueOrFalse);
    }

    public static int setAbstractFlag(int accessFlags, boolean trueOrFalse) {
        return JavaCGByteCodeUtil.setFlag(accessFlags, 1024, trueOrFalse);
    }

    private static int setFlag(int accessFlags, int flag, boolean trueOrFalse) {
        if ((accessFlags & flag) != 0) {
            if (!trueOrFalse) {
                accessFlags ^= flag;
            }
        } else if (trueOrFalse) {
            accessFlags |= flag;
        }
        return accessFlags;
    }

    public static Signature getSignatureOfClass(JavaClass javaClass) {
        for (Attribute attribute : javaClass.getAttributes()) {
            if (!(attribute instanceof Signature)) continue;
            return (Signature)attribute;
        }
        return null;
    }

    public static List<InnerClassInfo> getInnerClassInfo(JavaClass javaClass) {
        ArrayList<InnerClassInfo> innerClassInfoList = new ArrayList<InnerClassInfo>(0);
        String className = javaClass.getClassName();
        ConstantPool constantPool = javaClass.getConstantPool();
        for (Attribute attribute : javaClass.getAttributes()) {
            if (!(attribute instanceof InnerClasses)) continue;
            InnerClasses innerClasses = (InnerClasses)attribute;
            for (InnerClass innerClass : innerClasses.getInnerClasses()) {
                int innerClassIndex = innerClass.getInnerClassIndex();
                if (innerClassIndex == javaClass.getClassNameIndex()) continue;
                String innerClassName = constantPool.getConstantString(innerClassIndex, (byte)7);
                if (JavaCGUtil.isClassInJdk(innerClassName = Utility.compactClassName((String)innerClassName, (boolean)false)) || !innerClassName.startsWith(className) || StringUtils.countMatches((CharSequence)innerClassName, (char)'$') < StringUtils.countMatches((CharSequence)className, (char)'$')) continue;
                InnerClassInfo innerClassInfo = new InnerClassInfo(innerClassName, className, JavaCGUtil.isInnerAnonymousClass(innerClassName));
                innerClassInfoList.add(innerClassInfo);
            }
        }
        return innerClassInfoList;
    }

    private JavaCGByteCodeUtil() {
        throw new IllegalStateException("illegal");
    }
}

