/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.exceptions.JavaCGRuntimeException;
import com.adrninistrator.javacg.extensions.annotation_attributes.AnnotationAttributesFormatterInterface;
import com.adrninistrator.javacg.util.JavaCGFileUtil;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ArrayElementValue;
import org.apache.bcel.classfile.ClassElementValue;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.SimpleElementValue;
import org.apache.bcel.classfile.Utility;
import org.apache.commons.lang3.StringUtils;

public class JavaCGAnnotationUtil {
    public static String getAnnotationAttributeStringValue(AnnotationEntry annotationEntry, String ... annotationAttributeNames) {
        for (ElementValuePair elementValuePair : annotationEntry.getElementValuePairs()) {
            ElementValue elementValue = elementValuePair.getValue();
            if (!StringUtils.equalsAny((CharSequence)elementValuePair.getNameString(), (CharSequence[])annotationAttributeNames)) continue;
            if (elementValue instanceof SimpleElementValue) {
                return elementValue.toString();
            }
            if (elementValue instanceof ClassElementValue) {
                ClassElementValue classElementValue = (ClassElementValue)elementValue;
                return Utility.typeSignatureToString((String)classElementValue.getClassString(), (boolean)false);
            }
            throw new JavaCGRuntimeException("\u6ce8\u89e3\u5c5e\u6027\u7c7b\u578b\u4e0d\u7b26\u5408\u9884\u671f " + elementValuePair.getNameString() + " " + elementValue.getClass().getName());
        }
        return null;
    }

    public static List<String> getAnnotationAttributeStringArrayValue(AnnotationEntry annotationEntry, String ... annotationAttributeNames) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (ElementValuePair elementValuePair : annotationEntry.getElementValuePairs()) {
            if (!StringUtils.equalsAny((CharSequence)elementValuePair.getNameString(), (CharSequence[])annotationAttributeNames)) continue;
            ElementValue elementValue = elementValuePair.getValue();
            if (!(elementValue instanceof ArrayElementValue)) {
                throw new JavaCGRuntimeException("\u6ce8\u89e3\u5c5e\u6027\u7c7b\u578b\u4e0d\u7b26\u5408\u9884\u671f " + elementValuePair.getNameString() + " " + elementValue.getClass().getName());
            }
            ArrayElementValue arrayElementValue = (ArrayElementValue)elementValue;
            for (ElementValue elementValueOfArray : arrayElementValue.getElementValuesArray()) {
                if (!(elementValueOfArray instanceof SimpleElementValue)) {
                    throw new JavaCGRuntimeException("\u6ce8\u89e3\u5c5e\u6027\u7c7b\u578b\u4e0d\u7b26\u5408\u9884\u671f " + elementValuePair.getNameString() + " " + elementValue.getClass().getName());
                }
                SimpleElementValue simpleElementValue = (SimpleElementValue)elementValueOfArray;
                stringList.add(simpleElementValue.toString());
            }
            return stringList;
        }
        return stringList;
    }

    public static void writeAnnotationInfo(String classOrMethod, AnnotationEntry[] annotationEntries, AnnotationAttributesFormatterInterface annotationAttributesFormatter, Writer writer) {
        if (annotationEntries == null || annotationEntries.length == 0) {
            return;
        }
        try {
            for (AnnotationEntry annotationEntry : annotationEntries) {
                String annotationClassName = Utility.typeSignatureToString((String)annotationEntry.getAnnotationType(), (boolean)false);
                if (annotationEntry.getElementValuePairs() == null || annotationEntry.getElementValuePairs().length == 0) {
                    JavaCGFileUtil.write2FileWithTab(writer, classOrMethod, annotationClassName);
                    continue;
                }
                for (ElementValuePair elementValuePair : annotationEntry.getElementValuePairs()) {
                    String formattedValue = annotationAttributesFormatter.format(elementValuePair);
                    JavaCGFileUtil.write2FileWithTab(writer, classOrMethod, annotationClassName, elementValuePair.getNameString(), formattedValue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JavaCGAnnotationUtil() {
        throw new IllegalStateException("illegal");
    }
}

