/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.spring;

import com.adrninistrator.javacg.dto.classes.ClassExtendsMethodInfo;
import com.adrninistrator.javacg.dto.classes.ClassImplementsMethodInfo;
import com.adrninistrator.javacg.dto.interfaces.InterfaceExtendsMethodInfo;
import com.adrninistrator.javacg.extensions.code_parser.SpringXmlBeanParserInterface;
import com.adrninistrator.javacg.spring.DefineSpringBeanByAnnotationHandler;
import com.adrninistrator.javacg.util.JavaCGAnnotationUtil;
import com.adrninistrator.javacg.util.JavaCGLogUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.commons.lang3.StringUtils;

public class UseSpringBeanByAnnotationHandler {
    private final Map<String, ClassExtendsMethodInfo> classExtendsMethodInfoMap;
    private final Map<String, ClassImplementsMethodInfo> classImplementsMethodInfoMap;
    private final Map<String, InterfaceExtendsMethodInfo> interfaceExtendsMethodInfoMap;
    private final DefineSpringBeanByAnnotationHandler defineSpringBeanByAnnotationHandler;
    private final SpringXmlBeanParserInterface springXmlBeanParser;
    private final Map<String, Map<String, String>> classFieldSpringBeanNameMap = new HashMap<String, Map<String, String>>(100);
    private final Map<String, Map<String, String>> classFieldSpringBeanTypeMap = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> classAutowiredFieldInfoMap = new HashMap<String, Map<String, String>>(100);
    private final Map<String, Map<String, List<String>>> classAutowiredFieldMatchedTypeMap = new HashMap<String, Map<String, List<String>>>(100);
    private boolean useSpringBean = false;

    public UseSpringBeanByAnnotationHandler(Map<String, ClassExtendsMethodInfo> classExtendsMethodInfoMap, Map<String, ClassImplementsMethodInfo> classImplementsMethodInfoMap, Map<String, InterfaceExtendsMethodInfo> interfaceExtendsMethodInfoMap, DefineSpringBeanByAnnotationHandler defineSpringBeanByAnnotationHandler, SpringXmlBeanParserInterface springXmlBeanParser) {
        this.classExtendsMethodInfoMap = classExtendsMethodInfoMap;
        this.classImplementsMethodInfoMap = classImplementsMethodInfoMap;
        this.interfaceExtendsMethodInfoMap = interfaceExtendsMethodInfoMap;
        this.defineSpringBeanByAnnotationHandler = defineSpringBeanByAnnotationHandler;
        this.springXmlBeanParser = springXmlBeanParser;
        if (springXmlBeanParser != null) {
            System.out.println("\u6307\u5b9a" + SpringXmlBeanParserInterface.class.getSimpleName() + "\u5b9e\u4f8b " + springXmlBeanParser.getClass().getName());
        } else {
            System.out.println("\u672a\u6307\u5b9a" + SpringXmlBeanParserInterface.class.getSimpleName() + "\u5b9e\u4f8b");
        }
    }

    public void recordClassFieldsWithSpringAnnotation(JavaClass javaClass) {
        String className = javaClass.getClassName();
        HashMap<String, String> fieldSpringBeanNameMap = new HashMap<String, String>(10);
        HashMap<String, String> fieldSpringBeanTypeMap = new HashMap<String, String>(2);
        for (Field field : javaClass.getFields()) {
            this.handleFieldWithSpringAnnotation(className, field, fieldSpringBeanNameMap, fieldSpringBeanTypeMap);
        }
        if (!fieldSpringBeanNameMap.isEmpty()) {
            this.useSpringBean = true;
            this.classFieldSpringBeanNameMap.put(className, fieldSpringBeanNameMap);
        }
        if (!fieldSpringBeanTypeMap.isEmpty()) {
            this.useSpringBean = true;
            this.classFieldSpringBeanTypeMap.put(className, fieldSpringBeanTypeMap);
        }
    }

    private void handleFieldWithSpringAnnotation(String className, Field field, Map<String, String> fieldSpringBeanNameMap, Map<String, String> fieldSpringBeanTypeMap) {
        String typeAttributeValue;
        String fieldName = field.getName();
        AnnotationEntry resourceAnnotationEntry = null;
        AnnotationEntry autowiredAnnotationEntry = null;
        AnnotationEntry qualifierAnnotationEntry = null;
        AnnotationEntry namedAnnotationEntry = null;
        AnnotationEntry injectAnnotationEntry = null;
        for (AnnotationEntry annotationEntry : field.getAnnotationEntries()) {
            if ("Ljavax/annotation/Resource;".equals(annotationEntry.getAnnotationType())) {
                resourceAnnotationEntry = annotationEntry;
                continue;
            }
            if ("Lorg/springframework/beans/factory/annotation/Autowired;".equals(annotationEntry.getAnnotationType())) {
                autowiredAnnotationEntry = annotationEntry;
                continue;
            }
            if ("Lorg/springframework/beans/factory/annotation/Qualifier;".equals(annotationEntry.getAnnotationType())) {
                qualifierAnnotationEntry = annotationEntry;
                continue;
            }
            if ("Ljavax/inject/Named;".equals(annotationEntry.getAnnotationType())) {
                namedAnnotationEntry = annotationEntry;
                continue;
            }
            if (!"Ljavax/inject/Inject;".equals(annotationEntry.getAnnotationType())) continue;
            injectAnnotationEntry = annotationEntry;
        }
        if (resourceAnnotationEntry != null && (typeAttributeValue = JavaCGAnnotationUtil.getAnnotationAttributeStringValue(resourceAnnotationEntry, "type")) != null) {
            fieldSpringBeanTypeMap.put(fieldName, typeAttributeValue);
            return;
        }
        String beanName = this.getSpringBeanNameOfField(resourceAnnotationEntry, autowiredAnnotationEntry, qualifierAnnotationEntry, namedAnnotationEntry, injectAnnotationEntry, fieldName);
        if (beanName == null) {
            return;
        }
        if (autowiredAnnotationEntry != null && qualifierAnnotationEntry == null || injectAnnotationEntry != null) {
            Map autowiredFieldInfoMap = this.classAutowiredFieldInfoMap.computeIfAbsent(className, k -> new HashMap());
            autowiredFieldInfoMap.put(fieldName, field.getType().toString());
        }
        fieldSpringBeanNameMap.put(fieldName, beanName);
    }

    private String getSpringBeanNameOfField(AnnotationEntry resourceAnnotationEntry, AnnotationEntry autowiredAnnotationEntry, AnnotationEntry qualifierAnnotationEntry, AnnotationEntry namedAnnotationEntry, AnnotationEntry injectAnnotationEntry, String fieldName) {
        if (resourceAnnotationEntry == null && autowiredAnnotationEntry == null && injectAnnotationEntry == null) {
            return null;
        }
        if (resourceAnnotationEntry != null) {
            String nameOfResource = JavaCGAnnotationUtil.getAnnotationAttributeStringValue(resourceAnnotationEntry, "name");
            if (nameOfResource == null) {
                return fieldName;
            }
            return nameOfResource;
        }
        if (injectAnnotationEntry != null) {
            if (namedAnnotationEntry == null) {
                return fieldName;
            }
            String valueOfNamed = JavaCGAnnotationUtil.getAnnotationAttributeStringValue(namedAnnotationEntry, "value");
            if (StringUtils.isBlank((CharSequence)valueOfNamed)) {
                return fieldName;
            }
            return valueOfNamed;
        }
        if (qualifierAnnotationEntry == null) {
            return fieldName;
        }
        String valueOfQualifier = JavaCGAnnotationUtil.getAnnotationAttributeStringValue(qualifierAnnotationEntry, "value");
        if (StringUtils.isBlank((CharSequence)valueOfQualifier)) {
            return fieldName;
        }
        return valueOfQualifier;
    }

    public List<String> getSpringBeanTypeList(String className, String fieldName) {
        String springBeanTypeInXml;
        String springBeanType = this.getSpringBeanTypeByAnnotationType(className, fieldName);
        if (springBeanType != null) {
            return Collections.singletonList(springBeanType);
        }
        String springBeanName = this.getSpringBeanName(className, fieldName);
        if (springBeanName == null) {
            return Collections.emptyList();
        }
        List<String> springBeanTypeList = this.defineSpringBeanByAnnotationHandler.getSpringBeanTypeList(springBeanName);
        if (!JavaCGUtil.isCollectionEmpty(springBeanTypeList)) {
            return this.checkAutowiredTypeMatches(className, fieldName, springBeanTypeList);
        }
        if (this.springXmlBeanParser != null && (springBeanTypeInXml = this.springXmlBeanParser.getBeanClass(springBeanName)) != null) {
            return Collections.singletonList(springBeanTypeInXml);
        }
        return Collections.emptyList();
    }

    private List<String> checkAutowiredTypeMatches(String className, String fieldName, List<String> springBeanTypeList) {
        Map<String, String> autowiredFieldInfoMap = this.classAutowiredFieldInfoMap.get(className);
        if (autowiredFieldInfoMap == null) {
            return springBeanTypeList;
        }
        String fieldType = autowiredFieldInfoMap.get(fieldName);
        if (fieldType == null) {
            return springBeanTypeList;
        }
        Map autowiredFieldMatchedTypeMap = this.classAutowiredFieldMatchedTypeMap.computeIfAbsent(className, k -> new HashMap());
        List cachedMatchedTypeList = (List)autowiredFieldMatchedTypeMap.get(fieldName);
        if (cachedMatchedTypeList != null) {
            return cachedMatchedTypeList;
        }
        ArrayList<String> matchedSpringBeanTypeList = new ArrayList<String>(springBeanTypeList.size());
        for (String springBeanType : springBeanTypeList) {
            if (springBeanType.equals(fieldType) || JavaCGUtil.isChildOf(springBeanType, fieldType, this.classExtendsMethodInfoMap) || JavaCGUtil.isImplementationOf(springBeanType, fieldType, this.classExtendsMethodInfoMap, this.classImplementsMethodInfoMap, this.interfaceExtendsMethodInfoMap)) {
                matchedSpringBeanTypeList.add(springBeanType);
                continue;
            }
            String errorMsg = "eee \u4ee5\u4e0b\u7c7b\u83b7\u53d6\u5230\u7684\u5b57\u6bb5\u7684Spring Bean\u7c7b\u578b\u4e0e\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d " + className + " " + fieldName + " " + springBeanType + " " + fieldType;
            if (JavaCGLogUtil.isDebugPrintFlag()) {
                JavaCGLogUtil.debugPrint(errorMsg);
                continue;
            }
            System.err.println(errorMsg);
        }
        autowiredFieldMatchedTypeMap.put(fieldName, matchedSpringBeanTypeList);
        return matchedSpringBeanTypeList;
    }

    private String getSpringBeanTypeByAnnotationType(String className, String fieldName) {
        ClassExtendsMethodInfo classExtendsMethodInfo;
        String springBeanFieldType = this.doGetSpringBeanTypeByAnnotationType(className, fieldName);
        if (springBeanFieldType != null) {
            return springBeanFieldType;
        }
        String currentClassName = className;
        while ((classExtendsMethodInfo = this.classExtendsMethodInfoMap.get(currentClassName)) != null && !JavaCGUtil.isClassInJdk(currentClassName = classExtendsMethodInfo.getSuperClassName())) {
            springBeanFieldType = this.doGetSpringBeanTypeByAnnotationType(currentClassName, fieldName);
            if (springBeanFieldType == null) continue;
            Map fieldSpringBeanTypeMap = this.classFieldSpringBeanTypeMap.computeIfAbsent(className, k -> new HashMap());
            fieldSpringBeanTypeMap.put(fieldName, springBeanFieldType);
            break;
        }
        return springBeanFieldType;
    }

    private String doGetSpringBeanTypeByAnnotationType(String className, String fieldName) {
        Map<String, String> fieldSpringBeanTypeMap = this.classFieldSpringBeanTypeMap.get(className);
        if (fieldSpringBeanTypeMap == null) {
            return null;
        }
        return fieldSpringBeanTypeMap.get(fieldName);
    }

    private String getSpringBeanName(String className, String fieldName) {
        ClassExtendsMethodInfo classExtendsMethodInfo;
        String springBeanFieldName = this.doGetSpringBeanName(className, fieldName);
        if (springBeanFieldName != null) {
            return springBeanFieldName;
        }
        String currentClassName = className;
        while ((classExtendsMethodInfo = this.classExtendsMethodInfoMap.get(currentClassName)) != null && !JavaCGUtil.isClassInJdk(currentClassName = classExtendsMethodInfo.getSuperClassName())) {
            springBeanFieldName = this.doGetSpringBeanName(currentClassName, fieldName);
            if (springBeanFieldName == null) continue;
            Map fieldSpringBeanNameMap = this.classFieldSpringBeanNameMap.computeIfAbsent(className, k -> new HashMap());
            fieldSpringBeanNameMap.put(fieldName, springBeanFieldName);
            break;
        }
        return springBeanFieldName;
    }

    private String doGetSpringBeanName(String className, String fieldName) {
        Map<String, String> fieldSpringBeanNameMap = this.classFieldSpringBeanNameMap.get(className);
        if (fieldSpringBeanNameMap == null) {
            return null;
        }
        return fieldSpringBeanNameMap.get(fieldName);
    }

    public boolean hasUseSpringBean() {
        return this.useSpringBean;
    }
}

