/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.spring;

import com.adrninistrator.javacg.common.SpringAnnotationConstants;
import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.handler.MethodHandler4TypeAndValue;
import com.adrninistrator.javacg.util.JavaCGAnnotationUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.commons.lang3.StringUtils;

public class DefineSpringBeanByAnnotationHandler {
    private final JavaCGConfInfo javaCGConfInfo;
    private final Map<String, List<String>> stringBeanNameAndTypeMap = new HashMap<String, List<String>>(100);

    public DefineSpringBeanByAnnotationHandler(JavaCGConfInfo javaCGConfInfo) {
        this.javaCGConfInfo = javaCGConfInfo;
    }

    public boolean recordSpringBeanInfo(JavaClass javaClass) {
        for (AnnotationEntry annotationEntry : javaClass.getAnnotationEntries()) {
            String annotationType = annotationEntry.getAnnotationType();
            if (this.isSpringComponentAnnotation(annotationType)) {
                this.handleSpringComponentAnnotation(annotationEntry, javaClass.getClassName());
                continue;
            }
            if (!"Lorg/springframework/context/annotation/Configuration;".equals(annotationType) || this.handleSpringConfigurationAnnotation(javaClass)) continue;
            return false;
        }
        return true;
    }

    private boolean isSpringComponentAnnotation(String annotationType) {
        for (String annotation : SpringAnnotationConstants.SPRING_COMPONENT_ANNOTATIONS_RAW) {
            if (!annotation.equals(annotationType)) continue;
            return true;
        }
        return "Ljavax/inject/Named;".equals(annotationType);
    }

    private void handleSpringComponentAnnotation(AnnotationEntry annotationEntry, String className) {
        String valueAttributeValue = JavaCGAnnotationUtil.getAnnotationAttributeStringValue(annotationEntry, "value");
        if (StringUtils.isNotBlank((CharSequence)valueAttributeValue)) {
            this.stringBeanNameAndTypeMap.put(valueAttributeValue, Collections.singletonList(className));
            return;
        }
        String simpleClassName = JavaCGUtil.getSimpleClassNameFromFull(className);
        String firstLetterLowerClassName = JavaCGUtil.getFirstLetterLowerClassName(simpleClassName);
        this.stringBeanNameAndTypeMap.put(firstLetterLowerClassName, Collections.singletonList(className));
    }

    private boolean handleSpringConfigurationAnnotation(JavaClass javaClass) {
        for (Method method : javaClass.getMethods()) {
            for (AnnotationEntry annotationEntry : method.getAnnotationEntries()) {
                String annotationType = annotationEntry.getAnnotationType();
                if (!"Lorg/springframework/context/annotation/Bean;".equals(annotationType) || this.handleSpringBeanAnnotation(javaClass, method, annotationEntry)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean handleSpringBeanAnnotation(JavaClass javaClass, Method method, AnnotationEntry beanAnnotation) {
        MethodGen mg = new MethodGen(method, javaClass.getClassName(), new ConstantPoolGen(javaClass.getConstantPool()));
        MethodHandler4TypeAndValue methodHandler4TypeAndValue = new MethodHandler4TypeAndValue(mg, javaClass, this.javaCGConfInfo);
        methodHandler4TypeAndValue.setParseMethodCallTypeValueFlag(false);
        methodHandler4TypeAndValue.setRecordReturnPossibleInfoFlag(true);
        if (!methodHandler4TypeAndValue.handleMethod()) {
            return false;
        }
        List<String> returnPossibleTypeList = methodHandler4TypeAndValue.getReturnPossibleTypeList();
        if (returnPossibleTypeList == null) {
            return true;
        }
        List<String> nameAttributeValueList = JavaCGAnnotationUtil.getAnnotationAttributeStringArrayValue(beanAnnotation, "name", "value");
        if (!nameAttributeValueList.isEmpty()) {
            for (String nameAttributeValue : nameAttributeValueList) {
                this.stringBeanNameAndTypeMap.put(nameAttributeValue, returnPossibleTypeList);
            }
            return true;
        }
        this.stringBeanNameAndTypeMap.put(method.getName(), returnPossibleTypeList);
        return true;
    }

    public List<String> getSpringBeanTypeList(String beanName) {
        return this.stringBeanNameAndTypeMap.get(beanName);
    }

    public Set<String> getSpringBeanNameSet() {
        return this.stringBeanNameAndTypeMap.keySet();
    }
}

