/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.parser;

import com.adrninistrator.javacg.common.enums.JavaCGYesNoEnum;
import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.dto.classes.InnerClassInfo;
import com.adrninistrator.javacg.dto.counter.JavaCGCounter;
import com.adrninistrator.javacg.dto.jar.ClassAndJarNum;
import com.adrninistrator.javacg.dto.jar.JarInfo;
import com.adrninistrator.javacg.extensions.manager.ExtensionsManager;
import com.adrninistrator.javacg.handler.ClassHandler;
import com.adrninistrator.javacg.parser.AbstractJarEntryParser;
import com.adrninistrator.javacg.spring.UseSpringBeanByAnnotationHandler;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGFileUtil;
import com.adrninistrator.javacg.util.JavaCGLogUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import com.adrninistrator.javacg.writer.WriterSupportSkip;
import copy.javassist.bytecode.BadBytecode;
import copy.javassist.bytecode.SignatureAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Signature;

public class JarEntryHandleParser
extends AbstractJarEntryParser {
    private UseSpringBeanByAnnotationHandler useSpringBeanByAnnotationHandler;
    private Map<String, Boolean> runnableImplClassMap;
    private Map<String, Boolean> callableImplClassMap;
    private Map<String, Boolean> transactionCallbackImplClassMap;
    private Map<String, Boolean> transactionCallbackWithoutResultChildClassMap;
    private Map<String, Boolean> threadChildClassMap;
    private Writer jarInfoWriter;
    private Writer classNameWriter;
    private Writer methodCallWriter;
    private Writer lambdaMethodInfoWriter;
    private Writer classAnnotationWriter;
    private Writer methodAnnotationWriter;
    private Writer methodLineNumberWriter;
    private Writer methodCallInfoWriter;
    private Writer classInfoWriter;
    private Writer methodInfoWriter;
    private Writer extendsImplWriter;
    private Writer classSignatureEI1Writer;
    private Writer methodArgGenericsTypeWriter;
    private Writer methodReturnGenericsTypeWriter;
    private Writer innerClassWriter;
    private WriterSupportSkip logMethodSpendTimeWriter;
    private ExtensionsManager extensionsManager;
    private final Set<Integer> recordedJarNum = new HashSet<Integer>();
    private final Map<String, List<String>> handledClassNameMap = new HashMap<String, List<String>>();
    private final Map<String, List<String>> duplicateClassNameMap = new HashMap<String, List<String>>();
    private JavaCGCounter callIdCounter;
    private JavaCGCounter classNumCounter;
    private JavaCGCounter methodNumCounter;
    private ClassAndJarNum classAndJarNum;

    public JarEntryHandleParser(JavaCGConfInfo javaCGConfInfo, Map<String, JarInfo> jarInfoMap) {
        super(javaCGConfInfo, jarInfoMap);
    }

    @Override
    protected boolean handleEntry(JarInputStream jarInputStream, String jarEntryName) throws IOException {
        this.tryRecordJarInfo();
        if (!JavaCGFileUtil.isClassFile(jarEntryName)) {
            return true;
        }
        JavaClass javaClass = new ClassParser((InputStream)jarInputStream, jarEntryName).parse();
        return this.handleClassEntry(javaClass, jarEntryName);
    }

    @Override
    protected boolean handleClassEntry(JavaClass javaClass, String jarEntryName) throws IOException {
        return this.handleJavaClass(javaClass, jarEntryName);
    }

    private void tryRecordJarInfo() throws IOException {
        int lastJarNum = this.lastJarInfo.getJarNum();
        if (this.recordedJarNum.add(lastJarNum)) {
            JavaCGFileUtil.write2FileWithTab(this.jarInfoWriter, this.lastJarInfo.getJarType(), String.valueOf(lastJarNum), this.lastJarInfo.getJarPath());
        }
    }

    private boolean handleJavaClass(JavaClass javaClass, String jarEntryName) throws IOException {
        String className = javaClass.getClassName();
        if (JavaCGUtil.checkSkipClass(className, this.javaCGConfInfo.getNeedHandlePackageSet())) {
            if (JavaCGLogUtil.isDebugPrintFlag()) {
                JavaCGLogUtil.debugPrint("\u8df3\u8fc7\u4e0d\u9700\u8981\u5904\u7406\u7684\u7c7b: " + className);
            }
            return true;
        }
        List<String> classFilePathList = this.handledClassNameMap.get(className);
        if (classFilePathList != null) {
            classFilePathList.add(jarEntryName);
            this.duplicateClassNameMap.put(className, classFilePathList);
            if (JavaCGLogUtil.isDebugPrintFlag()) {
                JavaCGLogUtil.debugPrint("\u8df3\u8fc7\u5904\u7406\u91cd\u590d\u540c\u540dClass: " + className);
            }
            return true;
        }
        classFilePathList = new ArrayList<String>();
        classFilePathList.add(jarEntryName);
        this.handledClassNameMap.put(className, classFilePathList);
        if (JavaCGLogUtil.isDebugPrintFlag()) {
            JavaCGLogUtil.debugPrint("\u5904\u7406Class: " + className);
        }
        ClassHandler classHandler = new ClassHandler(javaClass, jarEntryName, this.javaCGConfInfo);
        classHandler.setUseSpringBeanByAnnotationHandler(this.useSpringBeanByAnnotationHandler);
        classHandler.setRunnableImplClassMap(this.runnableImplClassMap);
        classHandler.setCallableImplClassMap(this.callableImplClassMap);
        classHandler.setTransactionCallbackImplClassMap(this.transactionCallbackImplClassMap);
        classHandler.setTransactionCallbackWithoutResultChildClassMap(this.transactionCallbackWithoutResultChildClassMap);
        classHandler.setThreadChildClassMap(this.threadChildClassMap);
        classHandler.setCallIdCounter(this.callIdCounter);
        classHandler.setClassNameWriter(this.classNameWriter);
        classHandler.setClassAnnotationWriter(this.classAnnotationWriter);
        classHandler.setMethodAnnotationWriter(this.methodAnnotationWriter);
        classHandler.setMethodLineNumberWriter(this.methodLineNumberWriter);
        classHandler.setMethodCallWriter(this.methodCallWriter);
        classHandler.setLambdaMethodInfoWriter(this.lambdaMethodInfoWriter);
        classHandler.setMethodCallInfoWriter(this.methodCallInfoWriter);
        classHandler.setMethodInfoWriter(this.methodInfoWriter);
        classHandler.setMethodArgGenericsTypeWriter(this.methodArgGenericsTypeWriter);
        classHandler.setMethodReturnGenericsTypeWriter(this.methodReturnGenericsTypeWriter);
        classHandler.setLogMethodSpendTimeWriter(this.logMethodSpendTimeWriter);
        classHandler.setExtensionsManager(this.extensionsManager);
        classHandler.setMethodNumCounter(this.methodNumCounter);
        classHandler.setLastJarNum(this.lastJarInfo.getJarNum());
        classHandler.setClassAndJarNum(this.classAndJarNum);
        this.classNumCounter.addAndGet();
        if (!classHandler.handleClass()) {
            return false;
        }
        JavaCGFileUtil.write2FileWithTab(this.classInfoWriter, className, String.valueOf(javaClass.getAccessFlags()));
        this.recordExtendsAndImplInfo(javaClass, className);
        this.handleClassSignature(javaClass, className);
        this.handleInnerClass(javaClass);
        return true;
    }

    private void recordExtendsAndImplInfo(JavaClass javaClass, String className) throws IOException {
        String superClassName = javaClass.getSuperclassName();
        String accessFlagsStr = String.valueOf(javaClass.getAccessFlags());
        if (!JavaCGUtil.isObjectClass(superClassName)) {
            JavaCGFileUtil.write2FileWithTab(this.extendsImplWriter, className, accessFlagsStr, "e", superClassName);
        }
        for (String interfaceName : javaClass.getInterfaceNames()) {
            JavaCGFileUtil.write2FileWithTab(this.extendsImplWriter, className, accessFlagsStr, "i", interfaceName);
        }
    }

    private void handleClassSignature(JavaClass javaClass, String className) throws IOException {
        if (javaClass.isAnnotation()) {
            return;
        }
        Signature signature = JavaCGByteCodeUtil.getSignatureOfClass(javaClass);
        if (signature == null) {
            return;
        }
        try {
            SignatureAttribute.ClassType[] interfaceClassTypes;
            SignatureAttribute.ClassSignature signatureAttribute = SignatureAttribute.toClassSignature(signature.getSignature());
            SignatureAttribute.ClassType superClassType = signatureAttribute.getSuperClass();
            if (superClassType != null && !JavaCGUtil.isClassInJdk(superClassType.getName())) {
                this.recordSignatureArgumentInfo(className, "e", superClassType.getName(), superClassType);
            }
            if ((interfaceClassTypes = signatureAttribute.getInterfaces()) != null) {
                for (SignatureAttribute.ClassType interfaceClassType : interfaceClassTypes) {
                    if (JavaCGUtil.isClassInJdk(interfaceClassType.getName())) continue;
                    this.recordSignatureArgumentInfo(className, "i", interfaceClassType.getName(), interfaceClassType);
                }
            }
        }
        catch (BadBytecode e) {
            e.printStackTrace();
        }
    }

    private void handleInnerClass(JavaClass javaClass) throws IOException {
        List<InnerClassInfo> innerClassInfoList = JavaCGByteCodeUtil.getInnerClassInfo(javaClass);
        for (InnerClassInfo innerClassInfo : innerClassInfoList) {
            JavaCGFileUtil.write2FileWithTab(this.innerClassWriter, innerClassInfo.getInnerClassName(), innerClassInfo.getOuterClassName(), JavaCGYesNoEnum.parseStrValue(innerClassInfo.isAnonymousClass()));
        }
    }

    private void recordSignatureArgumentInfo(String className, String type, String superOrInterfaceName, SignatureAttribute.ClassType classType) throws IOException {
        if (classType.getTypeArguments() == null) {
            return;
        }
        int seq = 0;
        for (SignatureAttribute.TypeArgument typeArgument : classType.getTypeArguments()) {
            SignatureAttribute.ObjectType objectType = typeArgument.getType();
            if (!(objectType instanceof SignatureAttribute.ClassType)) continue;
            SignatureAttribute.ClassType argumentClassType = (SignatureAttribute.ClassType)objectType;
            JavaCGFileUtil.write2FileWithTab(this.classSignatureEI1Writer, className, type, superOrInterfaceName, String.valueOf(seq), argumentClassType.getName());
            ++seq;
        }
    }

    public Map<String, List<String>> getDuplicateClassNameMap() {
        return this.duplicateClassNameMap;
    }

    public void setUseSpringBeanByAnnotationHandler(UseSpringBeanByAnnotationHandler useSpringBeanByAnnotationHandler) {
        this.useSpringBeanByAnnotationHandler = useSpringBeanByAnnotationHandler;
    }

    public void setRunnableImplClassMap(Map<String, Boolean> runnableImplClassMap) {
        this.runnableImplClassMap = runnableImplClassMap;
    }

    public void setCallableImplClassMap(Map<String, Boolean> callableImplClassMap) {
        this.callableImplClassMap = callableImplClassMap;
    }

    public void setTransactionCallbackImplClassMap(Map<String, Boolean> transactionCallbackImplClassMap) {
        this.transactionCallbackImplClassMap = transactionCallbackImplClassMap;
    }

    public void setTransactionCallbackWithoutResultChildClassMap(Map<String, Boolean> transactionCallbackWithoutResultChildClassMap) {
        this.transactionCallbackWithoutResultChildClassMap = transactionCallbackWithoutResultChildClassMap;
    }

    public void setThreadChildClassMap(Map<String, Boolean> threadChildClassMap) {
        this.threadChildClassMap = threadChildClassMap;
    }

    public void setJarInfoWriter(Writer jarInfoWriter) {
        this.jarInfoWriter = jarInfoWriter;
    }

    public void setClassNameWriter(Writer classNameWriter) {
        this.classNameWriter = classNameWriter;
    }

    public void setMethodCallWriter(Writer methodCallWriter) {
        this.methodCallWriter = methodCallWriter;
    }

    public void setLambdaMethodInfoWriter(Writer lambdaMethodInfoWriter) {
        this.lambdaMethodInfoWriter = lambdaMethodInfoWriter;
    }

    public void setClassAnnotationWriter(Writer classAnnotationWriter) {
        this.classAnnotationWriter = classAnnotationWriter;
    }

    public void setMethodAnnotationWriter(Writer methodAnnotationWriter) {
        this.methodAnnotationWriter = methodAnnotationWriter;
    }

    public void setMethodLineNumberWriter(Writer methodLineNumberWriter) {
        this.methodLineNumberWriter = methodLineNumberWriter;
    }

    public void setMethodCallInfoWriter(Writer methodCallInfoWriter) {
        this.methodCallInfoWriter = methodCallInfoWriter;
    }

    public void setClassInfoWriter(Writer classInfoWriter) {
        this.classInfoWriter = classInfoWriter;
    }

    public void setMethodInfoWriter(Writer methodInfoWriter) {
        this.methodInfoWriter = methodInfoWriter;
    }

    public void setExtendsImplWriter(Writer extendsImplWriter) {
        this.extendsImplWriter = extendsImplWriter;
    }

    public void setClassSignatureEI1Writer(Writer classSignatureEI1Writer) {
        this.classSignatureEI1Writer = classSignatureEI1Writer;
    }

    public void setMethodArgGenericsTypeWriter(Writer methodArgGenericsTypeWriter) {
        this.methodArgGenericsTypeWriter = methodArgGenericsTypeWriter;
    }

    public void setMethodReturnGenericsTypeWriter(Writer methodReturnGenericsTypeWriter) {
        this.methodReturnGenericsTypeWriter = methodReturnGenericsTypeWriter;
    }

    public void setInnerClassWriter(Writer innerClassWriter) {
        this.innerClassWriter = innerClassWriter;
    }

    public void setLogMethodSpendTimeWriter(WriterSupportSkip logMethodSpendTimeWriter) {
        this.logMethodSpendTimeWriter = logMethodSpendTimeWriter;
    }

    public void setExtensionsManager(ExtensionsManager extensionsManager) {
        this.extensionsManager = extensionsManager;
    }

    public void setCallIdCounter(JavaCGCounter callIdCounter) {
        this.callIdCounter = callIdCounter;
    }

    public void setClassNumCounter(JavaCGCounter classNumCounter) {
        this.classNumCounter = classNumCounter;
    }

    public void setMethodNumCounter(JavaCGCounter methodNumCounter) {
        this.methodNumCounter = methodNumCounter;
    }

    public void setClassAndJarNum(ClassAndJarNum classAndJarNum) {
        this.classAndJarNum = classAndJarNum;
    }
}

