/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.handler;

import com.adrninistrator.javacg.common.enums.JavaCGCallTypeEnum;
import com.adrninistrator.javacg.common.enums.JavaCGCalleeObjTypeEnum;
import com.adrninistrator.javacg.common.enums.JavaCGYesNoEnum;
import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.dto.call.MethodCall;
import com.adrninistrator.javacg.dto.call.MethodCallList;
import com.adrninistrator.javacg.dto.call.MethodCallPossibleEntry;
import com.adrninistrator.javacg.dto.call.MethodCallPossibleInfo;
import com.adrninistrator.javacg.dto.call.MethodCallPossibleList;
import com.adrninistrator.javacg.dto.counter.JavaCGCounter;
import com.adrninistrator.javacg.dto.field.FieldPossibleTypes;
import com.adrninistrator.javacg.dto.field.FieldTypeAndName;
import com.adrninistrator.javacg.dto.jar.ClassAndJarNum;
import com.adrninistrator.javacg.dto.method.JavaCGMethodInfo;
import com.adrninistrator.javacg.extensions.annotation_attributes.AnnotationAttributesFormatterInterface;
import com.adrninistrator.javacg.extensions.code_parser.MethodAnnotationParser;
import com.adrninistrator.javacg.extensions.manager.ExtensionsManager;
import com.adrninistrator.javacg.handler.AbstractMethodHandler;
import com.adrninistrator.javacg.handler.MethodHandler4TypeAndValue;
import com.adrninistrator.javacg.spring.UseSpringBeanByAnnotationHandler;
import com.adrninistrator.javacg.util.JavaCGAnnotationUtil;
import com.adrninistrator.javacg.util.JavaCGBootstrapMethodUtil;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGFileUtil;
import com.adrninistrator.javacg.util.JavaCGInstructionUtil;
import com.adrninistrator.javacg.util.JavaCGLogUtil;
import com.adrninistrator.javacg.util.JavaCGMethodUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.BootstrapMethod;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.INVOKEDYNAMIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;
import org.apache.commons.lang3.StringUtils;

public class MethodHandler4Invoke
extends AbstractMethodHandler {
    private final UseSpringBeanByAnnotationHandler useSpringBeanByAnnotationHandler;
    private final String callerClassName;
    private final String callerMethodName;
    private final String callerMethodArgs;
    private final String callerFullMethod;
    private final MethodCallList methodCallList;
    private final Map<Integer, MethodCallPossibleInfo> methodCallInfoMap = new HashMap<Integer, MethodCallPossibleInfo>(50);
    private Map<String, Boolean> runnableImplClassMap;
    private Map<String, Boolean> callableImplClassMap;
    private Map<String, Boolean> transactionCallbackImplClassMap;
    private Map<String, Boolean> transactionCallbackWithoutResultChildClassMap;
    private Map<String, Boolean> threadChildClassMap;
    private ExtensionsManager extensionsManager;
    private AnnotationAttributesFormatterInterface annotationAttributesFormatter;
    private Writer methodCallWriter;
    private Writer lambdaMethodInfoWriter;
    private Writer methodAnnotationWriter;
    private Writer methodLineNumberWriter;
    private Writer methodCallInfoWriter;
    private int lastJarNum;
    private boolean existsSameMethodNameAndArgs;
    private FieldPossibleTypes nonStaticFieldPossibleTypes;
    private ClassAndJarNum classAndJarNum;

    public MethodHandler4Invoke(MethodGen mg, JavaClass javaClass, JavaCGConfInfo javaCGConfInfo, String callerMethodArgs, String callerFullMethod, UseSpringBeanByAnnotationHandler useSpringBeanByAnnotationHandler, JavaCGCounter callIdCounter) {
        super(mg, javaClass, javaCGConfInfo);
        this.callerClassName = javaClass.getClassName();
        this.callerMethodName = mg.getName();
        this.callerMethodArgs = callerMethodArgs;
        this.callerFullMethod = callerFullMethod;
        this.useSpringBeanByAnnotationHandler = useSpringBeanByAnnotationHandler;
        this.methodCallList = new MethodCallList(callIdCounter);
    }

    @Override
    protected boolean preHandleMethod() throws IOException {
        if (!this.existsSameMethodNameAndArgs) {
            JavaCGAnnotationUtil.writeAnnotationInfo(this.callerFullMethod, this.mg.getMethod().getAnnotationEntries(), this.annotationAttributesFormatter, this.methodAnnotationWriter);
            this.handleLineNumber(this.callerFullMethod);
        }
        this.handleMethodAnnotations();
        this.ih = JavaCGInstructionUtil.getFirstInstructionHandle(this.mg);
        return this.ih != null;
    }

    private void handleLineNumber(String callerFullMethod) throws IOException {
        if (this.lineNumberTable == null) {
            return;
        }
        LineNumber[] lineNumbers = this.lineNumberTable.getLineNumberTable();
        if (lineNumbers == null || lineNumbers.length == 0) {
            return;
        }
        int minLineNumber = lineNumbers[0].getLineNumber();
        int maxLineNumber = lineNumbers.length == 1 ? minLineNumber : lineNumbers[lineNumbers.length - 1].getLineNumber();
        JavaCGFileUtil.write2FileWithTab(this.methodLineNumberWriter, callerFullMethod, String.valueOf(minLineNumber), String.valueOf(maxLineNumber));
    }

    @Override
    protected boolean doHandleMethod() throws IOException {
        MethodHandler4TypeAndValue methodHandler4TypeAndValue = null;
        if (this.parseMethodCallTypeValueFlag) {
            methodHandler4TypeAndValue = new MethodHandler4TypeAndValue(this.mg, this.javaClass, this.javaCGConfInfo);
            methodHandler4TypeAndValue.setParseMethodCallTypeValueFlag(true);
            methodHandler4TypeAndValue.setRecordReturnPossibleInfoFlag(false);
            if (this.javaCGConfInfo.isFirstParseInitMethodType()) {
                methodHandler4TypeAndValue.setRecordFieldPossibleTypeFlag(false);
                methodHandler4TypeAndValue.setUseFieldPossibleTypeFlag(true);
                methodHandler4TypeAndValue.setNonStaticFieldPossibleTypes(this.nonStaticFieldPossibleTypes);
            }
            if (!methodHandler4TypeAndValue.handleMethod()) {
                return false;
            }
        }
        do {
            short opCode;
            if (JavaCGInstructionUtil.isMethodInvokeInstruction(opCode = this.ih.getInstruction().getOpcode())) {
                this.handleInvokeInstruction(methodHandler4TypeAndValue);
            }
            this.ih = this.ih.getNext();
        } while (this.ih != null);
        return true;
    }

    @Override
    protected boolean lastStep() throws IOException {
        for (MethodCall methodCall : this.methodCallList.getMethodCallList()) {
            String calleeClassJarNum = this.classAndJarNum.getJarNum(methodCall.getCalleeClassName());
            JavaCGFileUtil.write2FileWithTab(this.methodCallWriter, methodCall.genCallContent(String.valueOf(this.lastJarNum), calleeClassJarNum));
            this.handleMethodCallPossibleInfo(methodCall.getCallId(), this.methodCallInfoMap.get(methodCall.getCallId()));
        }
        return true;
    }

    private void handleMethodAnnotations() {
        for (AnnotationEntry annotationEntry : this.mg.getMethod().getAnnotationEntries()) {
            String annotationClassName = Utility.typeSignatureToString((String)annotationEntry.getAnnotationType(), (boolean)false);
            MethodAnnotationParser methodAnnotationParser = this.extensionsManager.getMethodAnnotationParser(annotationClassName);
            if (methodAnnotationParser == null) continue;
            methodAnnotationParser.parseMethodAnnotation(this.callerClassName, this.callerMethodName, this.callerMethodArgs, this.methodReturnType, annotationClassName, annotationEntry, this.methodCallList);
        }
    }

    private void handleInvokeInstruction(MethodHandler4TypeAndValue methodHandler4TypeAndValue) throws IOException {
        if (JavaCGLogUtil.isDebugPrintFlag()) {
            JavaCGLogUtil.debugPrint("%%% \u5904\u7406\u65b9\u6cd5\u8c03\u7528\u6307\u4ee4 " + JavaCGInstructionUtil.getInstructionHandlePrintInfo(this.ih) + " (" + this.getSourceLine() + ")");
        }
        MethodCallPossibleInfo methodCallPossibleInfo = null;
        if (this.parseMethodCallTypeValueFlag && methodHandler4TypeAndValue != null) {
            int position = this.ih.getPosition();
            methodCallPossibleInfo = methodHandler4TypeAndValue.getMethodCallPossibleInfo(position);
        }
        Instruction invokeInstruction = this.ih.getInstruction();
        switch (invokeInstruction.getOpcode()) {
            case 182: {
                this.handleINVOKEVIRTUAL((INVOKEVIRTUAL)invokeInstruction, methodCallPossibleInfo);
                break;
            }
            case 185: {
                this.handleINVOKEINTERFACE((INVOKEINTERFACE)invokeInstruction, methodCallPossibleInfo);
                break;
            }
            case 183: {
                this.handleINVOKESPECIAL((INVOKESPECIAL)invokeInstruction, methodCallPossibleInfo);
                break;
            }
            case 184: {
                this.handleINVOKESTATIC((INVOKESTATIC)invokeInstruction, methodCallPossibleInfo);
                break;
            }
            case 186: {
                this.handleINVOKEDYNAMIC((INVOKEDYNAMIC)invokeInstruction);
                break;
            }
            default: {
                System.err.println("\u4e0d\u4f1a\u6267\u884c\u5230\u6b64: " + invokeInstruction.getOpcode());
            }
        }
    }

    private void handleINVOKEVIRTUAL(INVOKEVIRTUAL invokevirtual, MethodCallPossibleInfo methodCallPossibleInfo) {
        JavaCGMethodInfo calleeMethodInfo = JavaCGInstructionUtil.getCalleeMethodInfo((InvokeInstruction)invokevirtual, this.cpg);
        String calleeClassName = calleeMethodInfo.getClassName();
        String calleeMethodName = calleeMethodInfo.getMethodName();
        Type[] calleeArguments = calleeMethodInfo.getMethodArgumentTypes();
        this.addMethodCall4ThreadStart(calleeClassName, calleeMethodName, calleeArguments);
        if (methodCallPossibleInfo == null) {
            this.addCommonMethodCall((InvokeInstruction)invokevirtual, JavaCGCallTypeEnum.CTE_RAW_INVOKE_VIRTUAL, null, calleeClassName, calleeMethodName, calleeArguments, null, null);
            return;
        }
        this.handleChangeableCalleeType((InvokeInstruction)invokevirtual, false, calleeClassName, calleeMethodName, calleeArguments, methodCallPossibleInfo);
    }

    private void handleINVOKEINTERFACE(INVOKEINTERFACE invokeinterface, MethodCallPossibleInfo methodCallPossibleInfo) {
        JavaCGMethodInfo calleeMethodInfo = JavaCGInstructionUtil.getCalleeMethodInfo((InvokeInstruction)invokeinterface, this.cpg);
        String calleeClassName = calleeMethodInfo.getClassName();
        String calleeMethodName = calleeMethodInfo.getMethodName();
        Type[] calleeArguments = calleeMethodInfo.getMethodArgumentTypes();
        if (methodCallPossibleInfo == null) {
            this.addCommonMethodCall((InvokeInstruction)invokeinterface, JavaCGCallTypeEnum.CTE_RAW_INVOKE_INTERFACE, null, calleeClassName, calleeMethodName, calleeArguments, null, null);
            return;
        }
        this.handleChangeableCalleeType((InvokeInstruction)invokeinterface, true, calleeClassName, calleeMethodName, calleeArguments, methodCallPossibleInfo);
    }

    private void handleINVOKESPECIAL(INVOKESPECIAL invokespecial, MethodCallPossibleInfo methodCallPossibleInfo) {
        Type[] calleeArguments;
        String calleeMethodName;
        JavaCGMethodInfo calleeMethodInfo = JavaCGInstructionUtil.getCalleeMethodInfo((InvokeInstruction)invokespecial, this.cpg);
        String calleeClassName = calleeMethodInfo.getClassName();
        boolean skipRawMethodCall = this.addMethodCall4SpecialInit(calleeClassName, calleeMethodName = calleeMethodInfo.getMethodName(), calleeArguments = calleeMethodInfo.getMethodArgumentTypes());
        if (skipRawMethodCall) {
            return;
        }
        JavaCGCallTypeEnum callTypeEnum = JavaCGCallTypeEnum.CTE_RAW_INVOKE_SPECIAL;
        if (!"<init>".equals(calleeMethodName) && calleeClassName.equals(this.javaClass.getSuperclassName()) && methodCallPossibleInfo != null && JavaCGCalleeObjTypeEnum.COTE_THIS == methodCallPossibleInfo.getObjTypeEnum()) {
            callTypeEnum = JavaCGCallTypeEnum.CTE_CHILD_CALL_SUPER_SPECIAL;
        }
        this.addCommonMethodCallWithInfo((InvokeInstruction)invokespecial, callTypeEnum, null, calleeClassName, calleeMethodName, calleeArguments, methodCallPossibleInfo);
    }

    private void handleINVOKESTATIC(INVOKESTATIC invokestatic, MethodCallPossibleInfo methodCallPossibleInfo) {
        JavaCGMethodInfo calleeMethodInfo = JavaCGInstructionUtil.getCalleeMethodInfo((InvokeInstruction)invokestatic, this.cpg);
        String calleeClassName = calleeMethodInfo.getClassName();
        String calleeMethodName = calleeMethodInfo.getMethodName();
        Type[] calleeArguments = calleeMethodInfo.getMethodArgumentTypes();
        this.addCommonMethodCallWithInfo((InvokeInstruction)invokestatic, JavaCGCallTypeEnum.CTE_RAW_INVOKE_STATIC, null, calleeClassName, calleeMethodName, calleeArguments, methodCallPossibleInfo);
    }

    private void handleINVOKEDYNAMIC(INVOKEDYNAMIC invokedynamic) throws IOException {
        Instruction nextInstruction;
        short nextOpcode;
        String calleeClassName = invokedynamic.getType(this.cpg).toString();
        String calleeMethodName = invokedynamic.getMethodName(this.cpg);
        Type[] calleeArguments = invokedynamic.getArgumentTypes(this.cpg);
        this.addCommonMethodCallWithInfo((InvokeInstruction)invokedynamic, JavaCGCallTypeEnum.CTE_RAW_INVOKE_DYNAMIC, null, calleeClassName, calleeMethodName, calleeArguments, null);
        Constant constant = this.cpg.getConstant(invokedynamic.getIndex());
        if (!(constant instanceof ConstantInvokeDynamic)) {
            return;
        }
        ConstantInvokeDynamic cid = (ConstantInvokeDynamic)constant;
        BootstrapMethod bootstrapMethod = JavaCGBootstrapMethodUtil.getBootstrapMethod(this.javaClass, cid.getBootstrapMethodAttrIndex());
        if (bootstrapMethod == null) {
            System.err.println("### \u65e0\u6cd5\u627e\u5230bootstrapMethod " + this.callerClassName + " " + cid.getBootstrapMethodAttrIndex());
            return;
        }
        JavaCGMethodInfo bootstrapMethodInfo = JavaCGBootstrapMethodUtil.getBootstrapMethodInfo(bootstrapMethod, this.javaClass);
        if (bootstrapMethodInfo == null) {
            System.err.println("### \u65e0\u6cd5\u627e\u5230bootstrapMethod\u7684\u65b9\u6cd5\u4fe1\u606f " + this.callerClassName + " " + bootstrapMethod);
            return;
        }
        MethodCall methodCall = this.addCommonMethodCall((InvokeInstruction)invokedynamic, JavaCGCallTypeEnum.CTE_LAMBDA, null, bootstrapMethodInfo.getClassName(), bootstrapMethodInfo.getMethodName(), bootstrapMethodInfo.getMethodArgumentTypes(), bootstrapMethodInfo.getMethodReturnType(), null);
        if (methodCall == null) {
            return;
        }
        String nextCalleeFullMethod = null;
        for (InstructionHandle nextIh = this.ih.getNext(); nextIh != null && JavaCGInstructionUtil.isMethodInvokeInstruction(nextOpcode = (nextInstruction = nextIh.getInstruction()).getOpcode()); nextIh = nextIh.getNext()) {
            if (!JavaCGInstructionUtil.isMethodInvokeInstructionExcludeDynamic(nextOpcode)) continue;
            JavaCGMethodInfo nextCalleeMethodInfo = JavaCGInstructionUtil.getCalleeMethodInfo((InvokeInstruction)nextInstruction, this.cpg);
            nextCalleeFullMethod = JavaCGMethodUtil.formatFullMethod(nextCalleeMethodInfo);
            break;
        }
        String calleeFullMethod = JavaCGMethodUtil.formatFullMethod(calleeClassName, calleeMethodName, calleeArguments);
        if (nextCalleeFullMethod == null) {
            JavaCGFileUtil.write2FileWithTab(this.lambdaMethodInfoWriter, String.valueOf(methodCall.getCallId()), calleeFullMethod);
        } else {
            JavaCGFileUtil.write2FileWithTab(this.lambdaMethodInfoWriter, String.valueOf(methodCall.getCallId()), calleeFullMethod, nextCalleeFullMethod);
        }
    }

    private void handleChangeableCalleeType(InvokeInstruction invokeInstruction, boolean isInterface, String calleeClassName, String calleeMethodName, Type[] arguments, MethodCallPossibleInfo methodCallPossibleInfo) {
        HashSet<String> handledCalleeTypeSet = new HashSet<String>();
        MethodCallPossibleList methodCallPossibleList4Object = methodCallPossibleInfo.getPossibleInfo4Object();
        if (this.useSpringBeanByAnnotationHandler.hasUseSpringBean() && methodCallPossibleList4Object.hasNonStaticField()) {
            for (MethodCallPossibleEntry methodCallPossibleEntry : methodCallPossibleList4Object.getMethodCallPossibleEntryList()) {
                List<String> springBeanFieldTypeList;
                FieldTypeAndName nonStaticField = methodCallPossibleEntry.getNonStaticField();
                if (nonStaticField == null || JavaCGUtil.isCollectionEmpty(springBeanFieldTypeList = this.useSpringBeanByAnnotationHandler.getSpringBeanTypeList(this.callerClassName, nonStaticField.getFieldName()))) continue;
                for (String springBeanFieldType : springBeanFieldTypeList) {
                    this.tryAddMethodCallWithType(invokeInstruction, isInterface, true, handledCalleeTypeSet, calleeClassName, springBeanFieldType, calleeMethodName, arguments, methodCallPossibleInfo);
                }
            }
        }
        if (methodCallPossibleList4Object.hasType()) {
            for (MethodCallPossibleEntry methodCallPossibleEntry : methodCallPossibleList4Object.getMethodCallPossibleEntryList()) {
                String type = methodCallPossibleEntry.getType();
                if (type == null) continue;
                this.tryAddMethodCallWithType(invokeInstruction, isInterface, false, handledCalleeTypeSet, calleeClassName, type, calleeMethodName, arguments, methodCallPossibleInfo);
            }
        }
        if (handledCalleeTypeSet.isEmpty()) {
            JavaCGCallTypeEnum callTypeEnum = isInterface ? JavaCGCallTypeEnum.CTE_RAW_INVOKE_INTERFACE : JavaCGCallTypeEnum.CTE_RAW_INVOKE_VIRTUAL;
            this.addCommonMethodCallWithInfo(invokeInstruction, callTypeEnum, null, calleeClassName, calleeMethodName, arguments, methodCallPossibleInfo);
        }
    }

    private JavaCGCallTypeEnum chooseActualCallType(boolean isInterface, boolean isSpringBean) {
        if (isSpringBean) {
            return isInterface ? JavaCGCallTypeEnum.CTE_SPRING_BEAN_ACTUAL_INTERFACE : JavaCGCallTypeEnum.CTE_SPRING_BEAN_ACTUAL_CLASS;
        }
        return isInterface ? JavaCGCallTypeEnum.CTE_ACTUAL_INTERFACE : JavaCGCallTypeEnum.CTE_ACTUAL_CLASS;
    }

    private void tryAddMethodCallWithType(InvokeInstruction invokeInstruction, boolean isInterface, boolean isSpringBean, Set<String> handledCalleeTypeSet, String calleeClassName, String calleeTypeRuntime, String calleeMethodName, Type[] arguments, MethodCallPossibleInfo methodCallPossibleInfo) {
        if (handledCalleeTypeSet.contains(calleeTypeRuntime) || StringUtils.equals((CharSequence)calleeClassName, (CharSequence)calleeTypeRuntime) || JavaCGByteCodeUtil.isNullType(calleeTypeRuntime) || JavaCGUtil.isObjectClass(calleeTypeRuntime)) {
            return;
        }
        JavaCGCallTypeEnum callTypeEnum = this.chooseActualCallType(isInterface, isSpringBean);
        this.addCommonMethodCallWithInfo(invokeInstruction, callTypeEnum, calleeTypeRuntime, calleeClassName, calleeMethodName, arguments, methodCallPossibleInfo);
        handledCalleeTypeSet.add(calleeTypeRuntime);
    }

    private void addCommonMethodCallWithInfo(InvokeInstruction invokeInstruction, JavaCGCallTypeEnum callTypeEnum, String calleeTypeRuntime, String calleeClassName, String calleeMethodName, Type[] arguments, MethodCallPossibleInfo methodCallPossibleInfo) {
        if (methodCallPossibleInfo == null) {
            this.addCommonMethodCall(invokeInstruction, callTypeEnum, calleeTypeRuntime, calleeClassName, calleeMethodName, arguments, null, null);
            return;
        }
        MethodCall methodCall = this.addCommonMethodCall(invokeInstruction, callTypeEnum, calleeTypeRuntime, calleeClassName, calleeMethodName, arguments, null, methodCallPossibleInfo.getObjTypeEnum());
        if (methodCall == null) {
            return;
        }
        this.methodCallInfoMap.put(methodCall.getCallId(), methodCallPossibleInfo);
    }

    private MethodCall addCommonMethodCall(InvokeInstruction invokeInstruction, JavaCGCallTypeEnum callTypeEnum, String calleeTypeRuntime, String calleeClassName, String calleeMethodName, Type[] calleeArgTypes, Type calleeReturnType, JavaCGCalleeObjTypeEnum objTypeEnum) {
        if (JavaCGUtil.checkSkipClass(calleeClassName, this.javaCGConfInfo.getNeedHandlePackageSet())) {
            return null;
        }
        String rawReturnType = "";
        String actualReturnType = "";
        if (invokeInstruction != null) {
            Instruction nextI;
            InstructionHandle nextIh;
            Type returnType = invokeInstruction.getReturnType(this.cpg);
            rawReturnType = returnType.toString();
            if (Type.VOID != returnType && (nextIh = this.ih.getNext()) != null && (nextI = nextIh.getInstruction()) instanceof CHECKCAST) {
                CHECKCAST checkcast = (CHECKCAST)nextI;
                actualReturnType = checkcast.getType(this.cpg).toString();
            }
        }
        MethodCall methodCall = new MethodCall(this.callerClassName, this.callerMethodName, this.callerMethodArgs, this.methodReturnType, callTypeEnum, calleeTypeRuntime != null ? calleeTypeRuntime : calleeClassName, calleeMethodName, JavaCGMethodUtil.getArgListStr(calleeArgTypes), this.getSourceLine(), objTypeEnum, calleeReturnType != null ? calleeReturnType.toString() : rawReturnType, actualReturnType);
        this.methodCallList.addMethodCall(methodCall);
        return methodCall;
    }

    private void addOtherMethodCall(String callerClassName, String callerMethodName, String callerMethodArgs, String callerReturnType, JavaCGCallTypeEnum methodCallType, String calleeClassName, String calleeMethodName, String calleeMethodArgs, String calleeReturnType, int callerSourceLine) {
        if (JavaCGUtil.checkSkipClass(calleeClassName, this.javaCGConfInfo.getNeedHandlePackageSet())) {
            return;
        }
        MethodCall methodCall = new MethodCall(callerClassName, callerMethodName, callerMethodArgs, callerReturnType, methodCallType, calleeClassName, calleeMethodName, calleeMethodArgs, callerSourceLine, null, calleeReturnType, null);
        this.methodCallList.addMethodCall(methodCall);
    }

    private boolean addMethodCall4SpecialInit(String calleeClassName, String calleeMethodName, Type[] arguments) {
        if (!JavaCGUtil.isInitMethod(calleeMethodName)) {
            return false;
        }
        boolean skipRawMethodCall = false;
        String calleeMethodArgs = JavaCGMethodUtil.getArgListStr(arguments);
        if (this.handleSpecialInitMethod(this.runnableImplClassMap, calleeClassName, calleeMethodName, calleeMethodArgs, JavaCGCallTypeEnum.CTE_RUNNABLE_INIT_RUN1, JavaCGCallTypeEnum.CTE_RUNNABLE_INIT_RUN2, "run", "()", "void")) {
            skipRawMethodCall = true;
        }
        if (this.handleSpecialInitMethod(this.callableImplClassMap, calleeClassName, calleeMethodName, calleeMethodArgs, JavaCGCallTypeEnum.CTE_CALLABLE_INIT_CALL1, JavaCGCallTypeEnum.CTE_CALLABLE_INIT_CALL2, "call", "()", "")) {
            skipRawMethodCall = true;
        }
        if (this.handleSpecialInitMethod(this.transactionCallbackImplClassMap, calleeClassName, calleeMethodName, calleeMethodArgs, JavaCGCallTypeEnum.CTE_TX_CALLBACK_INIT_CALL1, JavaCGCallTypeEnum.CTE_TX_CALLBACK_INIT_CALL2, "doInTransaction", "(org.springframework.transaction.TransactionStatus)", "")) {
            skipRawMethodCall = true;
        }
        if (this.handleSpecialInitMethod(this.transactionCallbackWithoutResultChildClassMap, calleeClassName, calleeMethodName, calleeMethodArgs, JavaCGCallTypeEnum.CTE_TX_CALLBACK_WR_INIT_CALL1, JavaCGCallTypeEnum.CTE_TX_CALLBACK_WR_INIT_CALL2, "doInTransactionWithoutResult", "(org.springframework.transaction.TransactionStatus)", "void")) {
            skipRawMethodCall = true;
        }
        return skipRawMethodCall;
    }

    private boolean handleSpecialInitMethod(Map<String, Boolean> map, String calleeClassName, String calleeMethodName, String calleeMethodArgs, JavaCGCallTypeEnum callTypeEnum1, JavaCGCallTypeEnum callTypeEnum2, String addedCalleeMethodName, String addedCalleeMethodArgs, String addedCalleeReturnType) {
        Boolean recorded = map.get(calleeClassName);
        if (recorded == null) {
            return false;
        }
        this.addOtherMethodCall(this.callerClassName, this.callerMethodName, this.callerMethodArgs, this.methodReturnType, callTypeEnum1, calleeClassName, calleeMethodName, calleeMethodArgs, "void", this.getSourceLine());
        if (Boolean.FALSE.equals(recorded)) {
            this.addOtherMethodCall(calleeClassName, calleeMethodName, calleeMethodArgs, "void", callTypeEnum2, calleeClassName, addedCalleeMethodName, addedCalleeMethodArgs, addedCalleeReturnType, 0);
            map.put(calleeClassName, Boolean.TRUE);
        }
        return true;
    }

    private void addMethodCall4ThreadStart(String calleeClassName, String calleeMethodName, Type[] arguments) {
        if (!"start".equals(calleeMethodName) || arguments.length > 0) {
            return;
        }
        if (!Boolean.FALSE.equals(this.threadChildClassMap.get(calleeClassName))) {
            return;
        }
        String calleeMethodArgs = JavaCGMethodUtil.getArgListStr(arguments);
        this.addOtherMethodCall(calleeClassName, calleeMethodName, calleeMethodArgs, "void", JavaCGCallTypeEnum.CTE_THREAD_START_RUN, calleeClassName, "run", "()", "void", 0);
        this.threadChildClassMap.put(calleeClassName, Boolean.TRUE);
    }

    private void handleMethodCallPossibleInfo(int methodCallId, MethodCallPossibleInfo methodCallPossibleInfo) throws IOException {
        if (methodCallPossibleInfo == null) {
            return;
        }
        this.recordMethodCallPossibleInfo(methodCallId, 0, methodCallPossibleInfo.getPossibleInfo4Object());
        for (int i = 0; i < methodCallPossibleInfo.getPossibleInfoNum4Args(); ++i) {
            this.recordMethodCallPossibleInfo(methodCallId, 1 + i, methodCallPossibleInfo.getPossibleInfo4Args(i));
        }
    }

    private void recordMethodCallPossibleInfo(int methodCallId, int argSeq, MethodCallPossibleList methodCallPossibleList) throws IOException {
        if (methodCallPossibleList == null) {
            return;
        }
        List<MethodCallPossibleEntry> methodCallPossibleEntryList = methodCallPossibleList.getMethodCallPossibleEntryList();
        if (JavaCGUtil.isCollectionEmpty(methodCallPossibleEntryList)) {
            return;
        }
        String arrayElementFlag = JavaCGYesNoEnum.parseStrValue(methodCallPossibleList.isArrayElement());
        StringBuilder stringBuilder = new StringBuilder();
        JavaCGCounter typeCounter = new JavaCGCounter(-1);
        for (int seq = 0; seq < methodCallPossibleEntryList.size(); ++seq) {
            MethodCallPossibleEntry methodCallPossibleEntry = methodCallPossibleEntryList.get(seq);
            this.recordStringMethodCallPossibleType(stringBuilder, methodCallPossibleEntry, methodCallId, argSeq, typeCounter, arrayElementFlag);
            this.recordStringMethodCallPossibleValue(stringBuilder, methodCallPossibleEntry, methodCallId, argSeq, seq, arrayElementFlag);
            this.recordStringMethodCallPossibleInfo(stringBuilder, methodCallPossibleEntry.getStaticFieldClassAndFieldName(), methodCallId, argSeq, "sf", seq, arrayElementFlag);
            this.recordStringMethodCallPossibleInfo(stringBuilder, methodCallPossibleEntry.getStaticFieldMethodCall(), methodCallId, argSeq, "sfm", seq, arrayElementFlag);
        }
        JavaCGFileUtil.write2FileNoLF(this.methodCallInfoWriter, stringBuilder.toString());
    }

    private void recordStringMethodCallPossibleType(StringBuilder stringBuilder, MethodCallPossibleEntry methodCallPossibleEntry, int methodCallId, int argSeq, JavaCGCounter typeCounter, String arrayElementFlag) {
        List<String> springBeanFieldTypeList;
        FieldTypeAndName nonStaticField;
        if (this.useSpringBeanByAnnotationHandler.hasUseSpringBean() && (nonStaticField = methodCallPossibleEntry.getNonStaticField()) != null && !JavaCGUtil.isCollectionEmpty(springBeanFieldTypeList = this.useSpringBeanByAnnotationHandler.getSpringBeanTypeList(this.callerClassName, nonStaticField.getFieldName()))) {
            for (String springBeanFieldType : springBeanFieldTypeList) {
                this.recordStringMethodCallPossibleInfo(stringBuilder, springBeanFieldType, methodCallId, argSeq, "t", typeCounter.addAndGet(), arrayElementFlag);
            }
            return;
        }
        String type = methodCallPossibleEntry.getType();
        if (type != null) {
            this.recordStringMethodCallPossibleInfo(stringBuilder, type, methodCallId, argSeq, "t", typeCounter.addAndGet(), arrayElementFlag);
        }
    }

    private void recordStringMethodCallPossibleInfo(StringBuilder stringBuilder, String data, int methodCallId, int argSeq, String type, int seq, String arrayElementFlag) {
        if (data == null) {
            return;
        }
        stringBuilder.append(methodCallId).append("\t").append(argSeq).append("\t").append(seq).append("\t").append(type).append("\t").append(arrayElementFlag).append("\t").append(data).append("\n");
    }

    private void recordStringMethodCallPossibleValue(StringBuilder stringBuilder, MethodCallPossibleEntry methodCallPossibleEntry, int methodCallId, int argSeq, int seq, String arrayElementFlag) {
        String finalValue;
        Object value = methodCallPossibleEntry.getValue();
        if (value == null) {
            return;
        }
        String type = "v";
        if (value instanceof String) {
            String strValue = (String)value;
            if (StringUtils.containsAny((CharSequence)strValue, (CharSequence[])new CharSequence[]{"\r", "\n", "\t"})) {
                finalValue = JavaCGUtil.base64Encode(strValue);
                type = "bv";
            } else {
                finalValue = strValue;
            }
        } else {
            finalValue = value.toString();
        }
        this.recordStringMethodCallPossibleInfo(stringBuilder, finalValue, methodCallId, argSeq, type, seq, arrayElementFlag);
    }

    public void setRunnableImplClassMap(Map<String, Boolean> runnableImplClassMap) {
        this.runnableImplClassMap = runnableImplClassMap;
    }

    public void setCallableImplClassMap(Map<String, Boolean> callableImplClassMap) {
        this.callableImplClassMap = callableImplClassMap;
    }

    public void setTransactionCallbackImplClassMap(Map<String, Boolean> transactionCallbackImplClassMap) {
        this.transactionCallbackImplClassMap = transactionCallbackImplClassMap;
    }

    public void setTransactionCallbackWithoutResultChildClassMap(Map<String, Boolean> transactionCallbackWithoutResultChildClassMap) {
        this.transactionCallbackWithoutResultChildClassMap = transactionCallbackWithoutResultChildClassMap;
    }

    public void setThreadChildClassMap(Map<String, Boolean> threadChildClassMap) {
        this.threadChildClassMap = threadChildClassMap;
    }

    public void setExtensionsManager(ExtensionsManager extensionsManager) {
        this.extensionsManager = extensionsManager;
        this.annotationAttributesFormatter = extensionsManager.getAnnotationAttributesFormatter();
    }

    public void setMethodCallWriter(Writer methodCallWriter) {
        this.methodCallWriter = methodCallWriter;
    }

    public void setLambdaMethodInfoWriter(Writer lambdaMethodInfoWriter) {
        this.lambdaMethodInfoWriter = lambdaMethodInfoWriter;
    }

    public void setMethodAnnotationWriter(Writer methodAnnotationWriter) {
        this.methodAnnotationWriter = methodAnnotationWriter;
    }

    public void setMethodLineNumberWriter(Writer methodLineNumberWriter) {
        this.methodLineNumberWriter = methodLineNumberWriter;
    }

    public void setMethodCallInfoWriter(Writer methodCallInfoWriter) {
        this.methodCallInfoWriter = methodCallInfoWriter;
    }

    public void setLastJarNum(int lastJarNum) {
        this.lastJarNum = lastJarNum;
    }

    public void setExistsSameMethodNameAndArgs(boolean existsSameMethodNameAndArgs) {
        this.existsSameMethodNameAndArgs = existsSameMethodNameAndArgs;
    }

    public void setNonStaticFieldPossibleTypes(FieldPossibleTypes nonStaticFieldPossibleTypes) {
        this.nonStaticFieldPossibleTypes = nonStaticFieldPossibleTypes;
    }

    public void setClassAndJarNum(ClassAndJarNum classAndJarNum) {
        this.classAndJarNum = classAndJarNum;
    }
}

