/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.handler;

import com.adrninistrator.javacg.common.enums.JavaCGConfigKeyEnum;
import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import java.io.IOException;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public abstract class AbstractMethodHandler {
    protected JavaClass javaClass;
    protected MethodGen mg;
    protected ConstantPoolGen cpg;
    protected LineNumberTable lineNumberTable;
    protected InstructionHandle ih;
    protected boolean parseMethodCallTypeValueFlag;
    protected JavaCGConfInfo javaCGConfInfo;
    protected String methodReturnType;

    protected AbstractMethodHandler(MethodGen mg, JavaClass javaClass, JavaCGConfInfo javaCGConfInfo) {
        this.javaClass = javaClass;
        this.mg = mg;
        this.javaCGConfInfo = javaCGConfInfo;
        this.cpg = mg.getConstantPool();
        this.lineNumberTable = mg.getLineNumberTable(this.cpg);
        this.methodReturnType = mg.getReturnType().toString();
    }

    protected abstract boolean preHandleMethod() throws IOException;

    protected abstract boolean doHandleMethod() throws IOException;

    protected boolean lastStep() throws IOException {
        return true;
    }

    public boolean handleMethod() {
        try {
            if (this.preHandleMethod() && !this.doHandleMethod()) {
                return false;
            }
            return this.lastStep();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("\u5904\u7406\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u9700\u8981\u5206\u6790\u539f\u56e0 " + this.javaClass.getClassName() + " " + this.mg.getName());
            if (this.javaCGConfInfo != null && !this.javaCGConfInfo.isContinueWhenError()) {
                System.out.println("\u5047\u5982\u5728\u5904\u7406\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\u65f6\u9700\u8981\u7ee7\u7eed\u6267\u884c\uff0c\u8bf7\u5728config.properties\u53c2\u6570\u4e2d\u6307\u5b9a" + JavaCGConfigKeyEnum.CKE_CONTINUE_WHEN_ERROR.getKey() + "=" + Boolean.TRUE);
                return false;
            }
            return true;
        }
    }

    protected int getSourceLine() {
        if (this.lineNumberTable == null) {
            return 0;
        }
        int sourceLine = this.lineNumberTable.getSourceLine(this.ih.getPosition());
        return Math.max(sourceLine, 0);
    }

    public void setParseMethodCallTypeValueFlag(boolean parseMethodCallTypeValueFlag) {
        this.parseMethodCallTypeValueFlag = parseMethodCallTypeValueFlag;
    }
}

