/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.extensions.manager;

import com.adrninistrator.javacg.dto.output.JavaCGOutputInfo;
import com.adrninistrator.javacg.exceptions.JavaCGRuntimeException;
import com.adrninistrator.javacg.extensions.annotation_attributes.AnnotationAttributesFormatterInterface;
import com.adrninistrator.javacg.extensions.annotation_attributes.DefaultAnnotationAttributesFormatter;
import com.adrninistrator.javacg.extensions.code_parser.AbstractSaveData2FileParser;
import com.adrninistrator.javacg.extensions.code_parser.CodeParserInterface;
import com.adrninistrator.javacg.extensions.code_parser.JarEntryOtherFileParser;
import com.adrninistrator.javacg.extensions.code_parser.MethodAnnotationParser;
import com.adrninistrator.javacg.extensions.code_parser.SpringXmlBeanParserInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ExtensionsManager {
    private final List<CodeParserInterface> allCodeParserList = new ArrayList<CodeParserInterface>();
    private final Map<String, List<JarEntryOtherFileParser>> otherFileParserMap = new HashMap<String, List<JarEntryOtherFileParser>>();
    private final Map<String, MethodAnnotationParser> methodAnnotationParserMap = new HashMap<String, MethodAnnotationParser>();
    private final List<AbstractSaveData2FileParser> saveData2FileParserList = new ArrayList<AbstractSaveData2FileParser>();
    private AnnotationAttributesFormatterInterface annotationAttributesFormatter;
    private SpringXmlBeanParserInterface springXmlBeanParser;
    private JavaCGOutputInfo javaCGOutputInfo;
    private boolean inited = false;

    public void addCodeParser(CodeParserInterface codeParser) {
        this.allCodeParserList.add(codeParser);
    }

    public boolean init() {
        if (this.inited) {
            throw new JavaCGRuntimeException("\u4e0d\u5141\u8bb8\u91cd\u590d\u521d\u59cb\u5316");
        }
        if (this.springXmlBeanParser != null) {
            this.allCodeParserList.add(this.springXmlBeanParser);
        }
        for (CodeParserInterface codeParser : this.allCodeParserList) {
            codeParser.initCodeParser();
            if (codeParser instanceof JarEntryOtherFileParser) {
                JarEntryOtherFileParser jarEntryOtherFileParser = (JarEntryOtherFileParser)codeParser;
                String[] otherFileExtensions = jarEntryOtherFileParser.chooseJarEntryOtherFileExt();
                if (otherFileExtensions != null) {
                    for (String otherFileExtension : otherFileExtensions) {
                        List otherFileParserList = this.otherFileParserMap.computeIfAbsent(otherFileExtension, k -> new ArrayList());
                        otherFileParserList.add(jarEntryOtherFileParser);
                    }
                }
                if (!(codeParser instanceof AbstractSaveData2FileParser)) continue;
                AbstractSaveData2FileParser saveData2FileParser = (AbstractSaveData2FileParser)codeParser;
                String outputFilePath = this.javaCGOutputInfo.addOtherFileInfo(saveData2FileParser.chooseFileName());
                if (!saveData2FileParser.init(outputFilePath)) {
                    System.err.println("\u521d\u59cb\u5316\u5931\u8d25 " + codeParser.getClass().getName());
                    return false;
                }
                this.saveData2FileParserList.add(saveData2FileParser);
                continue;
            }
            if (codeParser instanceof MethodAnnotationParser) {
                MethodAnnotationParser methodAnnotationParser = (MethodAnnotationParser)codeParser;
                String[] methodAnnotationClassNames = methodAnnotationParser.chooseMethodAnnotationClassName();
                if (methodAnnotationClassNames == null) continue;
                for (String methodAnnotationClass : methodAnnotationClassNames) {
                    this.methodAnnotationParserMap.put(methodAnnotationClass, methodAnnotationParser);
                }
                continue;
            }
            System.err.println("\u4e0d\u652f\u6301\u7684\u7c7b\u578b " + codeParser.getClass().getName());
            return false;
        }
        this.inited = true;
        return true;
    }

    public void close() {
        for (AbstractSaveData2FileParser saveData2FileParser : this.saveData2FileParserList) {
            saveData2FileParser.close();
        }
    }

    private void checkInited() {
        if (!this.inited) {
            throw new JavaCGRuntimeException("\u8fd8\u672a\u5b8c\u6210\u521d\u59cb\u5316");
        }
    }

    public List<JarEntryOtherFileParser> getJarEntryOtherFileParserList(String fileExtension) {
        this.checkInited();
        if (StringUtils.isBlank((CharSequence)fileExtension)) {
            return null;
        }
        return this.otherFileParserMap.get(fileExtension);
    }

    public MethodAnnotationParser getMethodAnnotationParser(String methodAnnotationClass) {
        this.checkInited();
        if (StringUtils.isBlank((CharSequence)methodAnnotationClass)) {
            return null;
        }
        return this.methodAnnotationParserMap.get(methodAnnotationClass);
    }

    public AnnotationAttributesFormatterInterface getAnnotationAttributesFormatter() {
        if (this.annotationAttributesFormatter == null) {
            this.annotationAttributesFormatter = new DefaultAnnotationAttributesFormatter();
        }
        return this.annotationAttributesFormatter;
    }

    public SpringXmlBeanParserInterface getSpringXmlBeanParser() {
        return this.springXmlBeanParser;
    }

    public void setSpringXmlBeanParser(SpringXmlBeanParserInterface springXmlBeanParser) {
        this.springXmlBeanParser = springXmlBeanParser;
    }

    public void setAnnotationAttributesFormatter(AnnotationAttributesFormatterInterface annotationAttributesFormatter) {
        this.annotationAttributesFormatter = annotationAttributesFormatter;
    }

    public void setJavaCGOutputInfo(JavaCGOutputInfo javaCGOutputInfo) {
        this.javaCGOutputInfo = javaCGOutputInfo;
    }
}

