/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.dto.frame;

import com.adrninistrator.javacg.dto.element.BaseElement;
import com.adrninistrator.javacg.exceptions.JavaCGRuntimeException;
import com.adrninistrator.javacg.util.JavaCGElementUtil;
import com.adrninistrator.javacg.util.JavaCGLogUtil;
import java.util.Set;

public class JavaCGOperandStack {
    private final BaseElement[] elements;
    private int head = 0;
    private final int capacity;

    public JavaCGOperandStack(int capacity) {
        this.elements = new BaseElement[capacity];
        this.capacity = capacity;
    }

    public int size() {
        return this.head;
    }

    public boolean isEmpty() {
        return this.head == 0;
    }

    public void push(BaseElement element) {
        if (element == null) {
            System.err.println("eee push\u7684\u5143\u7d20\u4e3anull " + this.head);
            throw new JavaCGRuntimeException("push\u7684\u5143\u7d20\u4e3anull");
        }
        if (this.head >= this.capacity) {
            System.err.println("eee \u6808\u5df2\u6ee1 " + this.head + " " + element);
            throw new JavaCGRuntimeException("\u6808\u5df2\u6ee1");
        }
        this.elements[this.head++] = element;
        if (JavaCGLogUtil.isDebugPrintFlag()) {
            JavaCGLogUtil.debugPrint("### \u5165\u64cd\u4f5c\u6570\u6808\u540e size: " + this.head + " " + element);
        }
    }

    public BaseElement pop() {
        if (this.head == 0) {
            System.err.println("eee \u6808\u4e3a\u7a7a\uff0c\u4e0d\u652f\u6301pop");
            throw new JavaCGRuntimeException("\u6808\u4e3a\u7a7a\uff0c\u4e0d\u652f\u6301pop");
        }
        BaseElement element = this.elements[--this.head];
        if (JavaCGLogUtil.isDebugPrintFlag()) {
            JavaCGLogUtil.debugPrint("### \u51fa\u64cd\u4f5c\u6570\u6808\u540e size: " + this.head + " " + element);
        }
        this.elements[this.head] = null;
        return element;
    }

    public BaseElement peek() {
        if (this.head == 0) {
            System.err.println("eee \u6808\u4e3a\u7a7a\uff0c\u4e0d\u652f\u6301peek");
            throw new JavaCGRuntimeException("\u6808\u4e3a\u7a7a\uff0c\u4e0d\u652f\u6301peek");
        }
        return this.elements[this.head - 1];
    }

    public BaseElement getFromTop(int interval) {
        int index = this.head - 1 - interval;
        if (index < 0) {
            return null;
        }
        return this.elements[index];
    }

    public void clear() {
        for (int i = 0; i < this.head; ++i) {
            this.elements[i] = null;
        }
        this.head = 0;
    }

    public JavaCGOperandStack copy() {
        JavaCGOperandStack clone = new JavaCGOperandStack(this.capacity);
        System.arraycopy(this.elements, 0, clone.elements, 0, this.head);
        clone.head = this.head;
        return clone;
    }

    public static void compareLooseMode(JavaCGOperandStack existed, JavaCGOperandStack added, Set<Integer> sameStackSeqSet) {
        if (existed.head != added.head) {
            return;
        }
        for (int i = 0; i < existed.head; ++i) {
            if (added.elements[i] != null && (existed.elements[i] == null || !JavaCGElementUtil.compare(existed.elements[i], added.elements[i]))) continue;
            sameStackSeqSet.add(i);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("head: ").append(this.head).append("\n");
        for (int i = 0; i < this.head; ++i) {
            BaseElement baseElement = this.elements[i];
            stringBuilder.append(i).append(" ");
            if (baseElement != null) {
                stringBuilder.append(baseElement);
            } else {
                stringBuilder.append("null");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

