/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.dto.frame;

import com.adrninistrator.javacg.dto.element.BaseElement;
import com.adrninistrator.javacg.dto.element.variable.FieldElement;
import com.adrninistrator.javacg.dto.element.variable.LocalVariableElement;
import com.adrninistrator.javacg.dto.element.variable.StaticFieldElement;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGElementUtil;
import com.adrninistrator.javacg.util.JavaCGLogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;

public class JavaCGLocalVariables {
    private List<LocalVariableElement> localVariableElementList;

    public JavaCGLocalVariables(MethodGen mg) {
        this.localVariableElementList = new ArrayList<LocalVariableElement>(mg.getMaxLocals());
        int index = 0;
        if (!mg.isStatic()) {
            LocalVariableElement thisLocalVariableElement = new LocalVariableElement(mg.getClassName(), false, null, index);
            this.localVariableElementList.add(thisLocalVariableElement);
            ++index;
        }
        for (Type arg : mg.getArgumentTypes()) {
            LocalVariableElement localVariableElement = new LocalVariableElement(arg.toString(), arg instanceof ArrayType, null, index);
            this.localVariableElementList.add(localVariableElement);
            ++index;
            if (localVariableElement.getElementSize() != 2) continue;
            this.localVariableElementList.add(null);
            ++index;
        }
    }

    public JavaCGLocalVariables copy() {
        JavaCGLocalVariables clone = new JavaCGLocalVariables();
        clone.localVariableElementList = new ArrayList<LocalVariableElement>(this.localVariableElementList);
        return clone;
    }

    public static void compareLooseMode(JavaCGLocalVariables existed, JavaCGLocalVariables added, Set<Integer> sameLocalsSeqSet) {
        if (added == null) {
            return;
        }
        int size = existed.localVariableElementList.size();
        if (size != added.size()) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            LocalVariableElement existedLocalVariable = existed.localVariableElementList.get(i);
            LocalVariableElement addedLocalVariable = added.localVariableElementList.get(i);
            if (addedLocalVariable != null && (existedLocalVariable == null || !JavaCGElementUtil.compare(existedLocalVariable, addedLocalVariable))) continue;
            sameLocalsSeqSet.add(i);
        }
    }

    public int size() {
        return this.localVariableElementList.size();
    }

    public LocalVariableElement get(int index) {
        return this.localVariableElementList.get(index);
    }

    public void add(String type, BaseElement baseElement, int index) {
        LocalVariableElement localVariableElement;
        if (baseElement instanceof StaticFieldElement) {
            StaticFieldElement staticFieldElement = (StaticFieldElement)baseElement;
            localVariableElement = new StaticFieldElement(type, staticFieldElement.isArrayElement(), staticFieldElement.getValue(), staticFieldElement.getFieldName(), staticFieldElement.getClassName(), index);
        } else if (baseElement instanceof FieldElement) {
            FieldElement fieldElement = (FieldElement)baseElement;
            localVariableElement = new FieldElement(type, fieldElement.isArrayElement(), fieldElement.getValue(), fieldElement.getFieldName(), index);
        } else {
            localVariableElement = new LocalVariableElement(type, baseElement.isArrayElement(), baseElement.getValue(), index);
        }
        if (baseElement.isArrayElement()) {
            localVariableElement.setArrayValueMap(baseElement.getArrayValueMap());
        }
        if (JavaCGLogUtil.isDebugPrintFlag()) {
            JavaCGLogUtil.debugPrint("### \u6dfb\u52a0\u672c\u5730\u53d8\u91cf (" + index + ") " + localVariableElement);
        }
        if (this.localVariableElementList.size() > index) {
            this.localVariableElementList.set(index, localVariableElement);
            return;
        }
        int nullElementNum = index - this.localVariableElementList.size();
        for (int i = 0; i < nullElementNum; ++i) {
            this.localVariableElementList.add(null);
        }
        this.localVariableElementList.add(localVariableElement);
        if (JavaCGByteCodeUtil.getTypeSize(type) == 2) {
            this.localVariableElementList.add(null);
        }
    }

    public void setValue2Null(int index) {
        LocalVariableElement localVariableElement = this.localVariableElementList.get(index);
        if (localVariableElement.getValue() == null) {
            return;
        }
        this.localVariableElementList.set(index, localVariableElement.copyWithNullValue());
    }

    private JavaCGLocalVariables() {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("num: ").append(this.localVariableElementList.size()).append("\n");
        for (int i = 0; i < this.localVariableElementList.size(); ++i) {
            LocalVariableElement localVariableElement = this.localVariableElementList.get(i);
            stringBuilder.append(i).append(" ");
            if (localVariableElement != null) {
                stringBuilder.append(localVariableElement);
            } else {
                stringBuilder.append("null");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

