/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.dto.frame;

import com.adrninistrator.javacg.dto.element.variable.FieldElement;
import com.adrninistrator.javacg.util.JavaCGElementUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FieldInformation {
    private Map<String, FieldElement> map = new HashMap<String, FieldElement>();

    public void put(String fieldName, FieldElement fieldElement) {
        this.map.put(fieldName, fieldElement);
    }

    public void putStatic(String className, String fieldName, FieldElement fieldElement) {
        this.map.put(this.getStaticKey(className, fieldName), fieldElement);
    }

    public FieldElement get(String fieldName) {
        return this.map.get(fieldName);
    }

    public FieldElement getStatic(String className, String fieldName) {
        return this.map.get(this.getStaticKey(className, fieldName));
    }

    private String getStaticKey(String className, String fieldName) {
        return className + ":" + fieldName;
    }

    public FieldInformation copy() {
        FieldInformation clone = new FieldInformation();
        clone.map = new HashMap<String, FieldElement>(this.map);
        return clone;
    }

    public int size() {
        return this.map.size();
    }

    public static void compareLooseMode(FieldInformation existed, FieldInformation added, Set<String> sameFieldInfoNameSet) {
        for (Map.Entry<String, FieldElement> entry : added.map.entrySet()) {
            String addedFieldName = entry.getKey();
            FieldElement addedFieldElement = entry.getValue();
            FieldElement existedFieldElement = existed.get(addedFieldName);
            if (existedFieldElement == null || !JavaCGElementUtil.compare(existedFieldElement, addedFieldElement)) continue;
            sameFieldInfoNameSet.add(addedFieldName);
        }
    }

    public String toString() {
        return "num: " + this.map.size();
    }
}

