/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.dto.element;

import com.adrninistrator.javacg.exceptions.JavaCGRuntimeException;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGLogUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseElement {
    protected String simpleClassName = this.getClass().getSimpleName();
    private String type;
    protected boolean arrayElement = false;
    private Map<Integer, BaseElement> arrayValueMap;
    protected Object value;

    public BaseElement() {
    }

    public BaseElement(String type, boolean arrayElement) {
        this.type = type;
        boolean bl = this.arrayElement = arrayElement || JavaCGByteCodeUtil.isArrayType(type);
        if (this.arrayElement) {
            this.arrayValueMap = new HashMap<Integer, BaseElement>();
        }
    }

    public int getElementSize() {
        return JavaCGByteCodeUtil.getTypeSize(this.getType());
    }

    public void checkTypeString(String expectedType) {
        if (!JavaCGLogUtil.isDebugPrintFlag()) {
            return;
        }
        String actualType = this.getType();
        if (JavaCGByteCodeUtil.isNullType(actualType)) {
            return;
        }
        if (JavaCGByteCodeUtil.compareType(actualType, expectedType)) {
            return;
        }
        JavaCGLogUtil.debugPrint("eee \u7c7b\u578b\u4e0e\u9884\u671f\u7684\u4e0d\u4e00\u81f4" + this + " expectedType: " + expectedType);
        System.err.println("eee \u7c7b\u578b\u4e0e\u9884\u671f\u7684\u4e0d\u4e00\u81f4\n" + this + "\nexpectedType:" + expectedType);
    }

    public void setElement(int index, BaseElement value) {
        if (!this.arrayElement) {
            throw new JavaCGRuntimeException("\u5f53\u524d\u7c7b\u4e0d\u662f\u6570\u7ec4\u7c7b\u578b");
        }
        this.arrayValueMap.put(index, value);
    }

    public Map<Integer, BaseElement> getArrayValueMap() {
        if (!this.arrayElement) {
            throw new JavaCGRuntimeException("\u5f53\u524d\u7c7b\u4e0d\u662f\u6570\u7ec4\u7c7b\u578b");
        }
        return this.arrayValueMap;
    }

    public void setArrayValueMap(Map<Integer, BaseElement> arrayValueMap) {
        this.arrayValueMap = arrayValueMap;
    }

    public String getType() {
        return this.type;
    }

    public boolean isArrayElement() {
        return this.arrayElement;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.simpleClassName + " type: " + this.getType() + " value: " + this.value + String.format(" (%x)", System.identityHashCode(this));
    }
}

