/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.dto.call;

import com.adrninistrator.javacg.common.enums.JavaCGCallTypeEnum;
import com.adrninistrator.javacg.common.enums.JavaCGCalleeObjTypeEnum;
import com.adrninistrator.javacg.util.JavaCGMethodUtil;
import org.apache.commons.lang3.StringUtils;

public class MethodCall {
    private int callId;
    private final String callerClassName;
    private final String callerMethodName;
    private final String callerMethodArgs;
    private String callerReturnType;
    private final JavaCGCallTypeEnum methodCallType;
    private final String calleeClassName;
    private final String calleeMethodName;
    private final String calleeMethodArgs;
    private final int callerSourceLine;
    private final JavaCGCalleeObjTypeEnum objTypeEnum;
    private final String rawReturnType;
    private final String actualReturnType;

    public MethodCall(int callId, String callerClassName, String callerMethodName, String callerMethodArgs, String callerReturnType, JavaCGCallTypeEnum methodCallType, String calleeClassName, String calleeMethodName, String calleeMethodArgs, int callerSourceLine, JavaCGCalleeObjTypeEnum objTypeEnum, String rawReturnType, String actualReturnType) {
        this(callerClassName, callerMethodName, callerMethodArgs, callerReturnType, methodCallType, calleeClassName, calleeMethodName, calleeMethodArgs, callerSourceLine, objTypeEnum, rawReturnType, actualReturnType);
        this.callId = callId;
    }

    public MethodCall(String callerClassName, String callerMethodName, String callerMethodArgs, String callerReturnType, JavaCGCallTypeEnum methodCallType, String calleeClassName, String calleeMethodName, String calleeMethodArgs, int callerSourceLine, JavaCGCalleeObjTypeEnum objTypeEnum, String rawReturnType, String actualReturnType) {
        this.callerClassName = callerClassName;
        this.callerMethodName = callerMethodName;
        this.callerMethodArgs = callerMethodArgs;
        this.callerReturnType = callerReturnType;
        this.methodCallType = methodCallType;
        this.calleeClassName = calleeClassName;
        this.calleeMethodName = calleeMethodName;
        this.calleeMethodArgs = calleeMethodArgs;
        this.callerSourceLine = callerSourceLine;
        this.objTypeEnum = objTypeEnum;
        this.rawReturnType = rawReturnType;
        this.actualReturnType = actualReturnType;
    }

    public String genCallerFullMethod() {
        return JavaCGMethodUtil.formatFullMethod(this.callerClassName, this.callerMethodName, this.callerMethodArgs);
    }

    public String genObjTypeEnum() {
        if (this.objTypeEnum == null) {
            return "";
        }
        return this.objTypeEnum.getType();
    }

    public String genCalleeFullMethod() {
        return JavaCGMethodUtil.formatFullMethod(this.calleeClassName, this.calleeMethodName, this.calleeMethodArgs);
    }

    public String genCallContent(String callerJarNum, String calleeJarNum) {
        return StringUtils.joinWith((String)"\t", (Object[])new Object[]{this.callId, this.genCallerFullMethod(), "(" + this.methodCallType.getType() + ")" + this.genCalleeFullMethod(), this.callerSourceLine, this.callerReturnType, this.genObjTypeEnum(), this.rawReturnType, this.actualReturnType, callerJarNum, calleeJarNum});
    }

    public int getCallId() {
        return this.callId;
    }

    public void setCallId(int callId) {
        this.callId = callId;
    }

    public String getCalleeClassName() {
        return this.calleeClassName;
    }
}

