/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.common.JavaCGConstants;
import com.adrninistrator.javacg.dto.ClassInterfaceMethodInfo;
import com.adrninistrator.javacg.dto.ExtendsClassMethodInfo;
import com.adrninistrator.javacg.dto.MethodInfo;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.BootstrapMethod;
import org.apache.bcel.classfile.BootstrapMethods;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantMethodHandle;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.Type;

public class JavaCGUtil {
    private static boolean debugPrintFlag = System.getProperty("debug.print") != null;

    public static boolean isInnerAnonymousClass(String className) {
        if (!className.contains("$")) {
            return false;
        }
        String[] array = className.split("\\$");
        if (array.length != 2) {
            return false;
        }
        return JavaCGUtil.isNumStr(array[1]);
    }

    public static boolean isNumStr(String str) {
        char[] charArray;
        if (str == null || str.isEmpty()) {
            return false;
        }
        for (char ch : charArray = str.toCharArray()) {
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    public static String getArgListStr(Type[] arguments) {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < arguments.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(arguments[i].toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public static List<String> genImplClassMethodWithArgs(Method[] methods) {
        ArrayList<String> methodInfoList = new ArrayList<String>(methods.length);
        for (Method method : methods) {
            String methodName = method.getName();
            if (methodName.startsWith("<") || !method.isPublic() || method.isAbstract() || method.isStatic()) continue;
            methodInfoList.add(methodName + JavaCGUtil.getArgListStr(method.getArgumentTypes()));
        }
        return methodInfoList;
    }

    public static List<String> genInterfaceAbstractMethodWithArgs(Method[] methods) {
        ArrayList<String> methodInfoList = new ArrayList<String>(methods.length);
        for (Method method : methods) {
            if (!method.isAbstract()) continue;
            methodInfoList.add(method.getName() + JavaCGUtil.getArgListStr(method.getArgumentTypes()));
        }
        return methodInfoList;
    }

    public static String getLambdaOrigMethod(String lambdaMethod) {
        int indexLastLambda = lambdaMethod.lastIndexOf("lambda$");
        String tmpString = lambdaMethod.substring(indexLastLambda + "lambda$".length());
        int indexDollar = tmpString.indexOf(36);
        return tmpString.substring(0, indexDollar);
    }

    public static int getFuncStartSourceLine(Method method) {
        LineNumberTable lineNumberTable = method.getLineNumberTable();
        if (lineNumberTable == null || lineNumberTable.getLineNumberTable() == null) {
            return 0;
        }
        return lineNumberTable.getLineNumberTable()[0].getLineNumber();
    }

    private static int getInitFuncStartSourceLine(JavaClass javaClass) {
        Method[] methods = javaClass.getMethods();
        if (methods == null) {
            return 0;
        }
        for (Method method : methods) {
            if (!"<init>".equals(method.getName())) continue;
            return JavaCGUtil.getFuncStartSourceLine(method);
        }
        return 0;
    }

    public static BootstrapMethod getBootstrapMethod(JavaClass javaClass, int index) {
        Attribute[] attributes;
        for (Attribute attribute : attributes = javaClass.getAttributes()) {
            BootstrapMethods bootstrapMethods;
            BootstrapMethod[] bootstrapMethodArray;
            if (!(attribute instanceof BootstrapMethods) || (bootstrapMethodArray = (bootstrapMethods = (BootstrapMethods)attribute).getBootstrapMethods()) == null || bootstrapMethodArray.length <= index) continue;
            return bootstrapMethodArray[index];
        }
        return null;
    }

    public static MethodInfo getBootstrapMethodInfo(BootstrapMethod bootstrapMethod, JavaClass javaClass) {
        for (int argIndex : bootstrapMethod.getBootstrapArguments()) {
            MethodInfo methodInfo;
            Constant constantArg = javaClass.getConstantPool().getConstant(argIndex);
            if (!(constantArg instanceof ConstantMethodHandle) || (methodInfo = JavaCGUtil.getMethodFromConstantMethodHandle((ConstantMethodHandle)constantArg, javaClass)) == null) continue;
            return methodInfo;
        }
        return null;
    }

    public static MethodInfo getMethodFromConstantMethodHandle(ConstantMethodHandle constantMethodHandle, JavaClass javaClass) {
        ConstantPool constantPool = javaClass.getConstantPool();
        Constant constantCP = constantPool.getConstant(constantMethodHandle.getReferenceIndex());
        if (!(constantCP instanceof ConstantCP)) {
            System.err.println("### \u4e0d\u6ee1\u8db3instanceof ConstantCP " + constantCP.getClass().getName());
            return null;
        }
        ConstantCP constantClassAndMethod = (ConstantCP)constantCP;
        String className = constantPool.getConstantString(constantClassAndMethod.getClassIndex(), (byte)7);
        className = Utility.compactClassName((String)className, (boolean)false);
        Constant constantNAT = constantPool.getConstant(constantClassAndMethod.getNameAndTypeIndex());
        if (!(constantNAT instanceof ConstantNameAndType)) {
            System.err.println("### \u4e0d\u6ee1\u8db3instanceof ConstantNameAndType " + constantNAT.getClass().getName());
            return null;
        }
        ConstantNameAndType constantNameAndType = (ConstantNameAndType)constantNAT;
        String methodName = constantPool.constantToString(constantNameAndType.getNameIndex(), (byte)1);
        String methodArgs = constantPool.constantToString(constantNameAndType.getSignatureIndex(), (byte)1);
        if (methodName != null && methodArgs != null) {
            MethodInfo methodInfo = new MethodInfo();
            methodInfo.setClassName(className);
            methodInfo.setMethodName(methodName);
            Type[] types = Type.getArgumentTypes((String)methodArgs);
            methodInfo.setMethodArgumentTypes(types);
            return methodInfo;
        }
        System.err.println("### \u83b7\u53d6\u65b9\u6cd5\u4fe1\u606f\u5931\u8d25 " + javaClass.getClassName() + " " + className + " " + methodName + " " + methodArgs);
        return null;
    }

    public static boolean isChildOf(String childClassName, String superClassName, Map<String, ExtendsClassMethodInfo> extendsClassMethodInfoMap) {
        if (childClassName == null || superClassName == null || extendsClassMethodInfoMap == null) {
            return false;
        }
        String currentClassName = childClassName;
        ExtendsClassMethodInfo extendsClassMethodInfo;
        while ((extendsClassMethodInfo = extendsClassMethodInfoMap.get(currentClassName)) != null) {
            if (superClassName.equals(extendsClassMethodInfo.getSuperClassName())) {
                return true;
            }
            currentClassName = extendsClassMethodInfo.getSuperClassName();
        }
        return false;
    }

    public static boolean isImplementationOf(String className, String interfaceName, Map<String, ExtendsClassMethodInfo> extendsClassMethodInfoMap, Map<String, ClassInterfaceMethodInfo> classInterfaceMethodInfoMap) {
        if (className == null || interfaceName == null || extendsClassMethodInfoMap == null || classInterfaceMethodInfoMap == null) {
            return false;
        }
        String currentClassName = className;
        ClassInterfaceMethodInfo classInterfaceMethodInfo;
        while ((classInterfaceMethodInfo = classInterfaceMethodInfoMap.get(currentClassName)) == null || classInterfaceMethodInfo.getInterfaceNameList() == null || !classInterfaceMethodInfo.getInterfaceNameList().contains(interfaceName)) {
            ExtendsClassMethodInfo extendsClassMethodInfo = extendsClassMethodInfoMap.get(currentClassName);
            if (extendsClassMethodInfo == null) {
                return false;
            }
            currentClassName = extendsClassMethodInfo.getSuperClassName();
        }
        return true;
    }

    public static List<String> getAllClassNameList(String className, Map<String, ExtendsClassMethodInfo> extendsClassMethodInfoMap) {
        ArrayList<String> classNameList = new ArrayList<String>();
        if (className == null || extendsClassMethodInfoMap == null) {
            return classNameList;
        }
        String currentClassName = className;
        while (true) {
            classNameList.add(currentClassName);
            ExtendsClassMethodInfo extendsClassMethodInfo = extendsClassMethodInfoMap.get(currentClassName);
            if (extendsClassMethodInfo == null || JavaCGConstants.OBJECT_CLASS_NAME.equals(extendsClassMethodInfo.getSuperClassName())) break;
            currentClassName = extendsClassMethodInfo.getSuperClassName();
        }
        return classNameList;
    }

    public static void debugPrint(String data) {
        if (!debugPrintFlag) {
            return;
        }
        System.out.println(data);
    }

    public static String handleClassNameWithArray(String className) {
        if (!className.startsWith("[")) {
            return className;
        }
        String tmpClassName = Utility.typeSignatureToString((String)className, (boolean)false);
        if (!tmpClassName.endsWith("[]")) {
            System.err.println("handleClassNameWithArray " + tmpClassName);
            return tmpClassName;
        }
        return tmpClassName.substring(0, tmpClassName.length() - "[]".length());
    }

    public static void writeAnnotationInfo(String type, String classOrMethod, AnnotationEntry[] annotationEntries, BufferedWriter writer) {
        if (annotationEntries == null || annotationEntries.length == 0) {
            return;
        }
        try {
            for (AnnotationEntry annotationEntry : annotationEntries) {
                String annotationClassName = Utility.typeSignatureToString((String)annotationEntry.getAnnotationType(), (boolean)false);
                String data = type + " " + classOrMethod + " " + annotationClassName;
                if (annotationEntry.getElementValuePairs() == null || annotationEntry.getElementValuePairs().length == 0) {
                    writer.write(data + "\n");
                }
                for (ElementValuePair elementValuePair : annotationEntry.getElementValuePairs()) {
                    String key = elementValuePair.getNameString();
                    String value = elementValuePair.getValue().toString();
                    value = JavaCGUtil.encodeAnnotationValue(value);
                    writer.write(data + " " + key + " " + value + "\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String encodeAnnotationValue(String value) {
        return value.replace(' ', '\u0001');
    }

    public static String decodeAnnotationValue(String value) {
        return value.replace('\u0001', ' ');
    }

    private JavaCGUtil() {
        throw new IllegalStateException("illegal");
    }
}

