/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.dto.JarInfo;
import com.adrninistrator.javacg.util.FileUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class HandleJarUtil {
    private static List<String> getMergeClassInJarPackageList() {
        ArrayList<String> mergeClassInJarPackageList = new ArrayList<String>();
        String mergeClassInJarPackageProperty = System.getProperty("merge.class.in.jar.package");
        if (mergeClassInJarPackageProperty == null || mergeClassInJarPackageProperty.trim().isEmpty()) {
            System.out.println("\u5408\u5e76jar/war\u5305\u4e2d\u7684class\u6587\u4ef6\u65f6\uff0c\u5168\u90e8\u90fd\u8fdb\u884c\u5408\u5e76\uff0c\u4e0d\u533a\u5206\u5305\u540d");
            return mergeClassInJarPackageList;
        }
        String[] mergeClassInJarPackageArray = mergeClassInJarPackageProperty.split("\\|");
        System.out.println("\u5408\u5e76jar/war\u5305\u4e2d\u7684class\u6587\u4ef6\u65f6\uff0c\u9700\u8981\u5408\u5e76\u7684\u5305\u540d");
        for (String mergeClassInJarPackage : mergeClassInJarPackageArray) {
            String newMergeClassInJarPackage;
            if (mergeClassInJarPackage.isEmpty() || (newMergeClassInJarPackage = mergeClassInJarPackage.replace(".", "/")).startsWith("/") && (newMergeClassInJarPackage = newMergeClassInJarPackage.substring(1)).isEmpty()) continue;
            if (!newMergeClassInJarPackage.endsWith("/")) {
                newMergeClassInJarPackage = newMergeClassInJarPackage + "/";
            }
            System.out.println(newMergeClassInJarPackage);
            mergeClassInJarPackageList.add(newMergeClassInJarPackage);
        }
        return mergeClassInJarPackageList;
    }

    public static String handleJar(String[] jarOrDirPathArray, Map<String, JarInfo> jarInfoMap) {
        if (jarOrDirPathArray.length == 1) {
            File oneFile = new File(jarOrDirPathArray[0]);
            String oneFilePath = FileUtil.getCanonicalPath(oneFile);
            if (!oneFile.exists()) {
                System.err.println("\u6307\u5b9a\u7684jar\u5305\u6216\u76ee\u5f55\u4e0d\u5b58\u5728: " + oneFilePath);
                return null;
            }
            if (oneFile.isFile()) {
                jarInfoMap.put(oneFile.getName(), JarInfo.genJarInfo("J:", oneFilePath));
                return oneFilePath;
            }
        }
        return HandleJarUtil.mergeJar(jarOrDirPathArray, jarInfoMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String mergeJar(String[] jarOrDirPathArray, Map<String, JarInfo> jarInfoMap) {
        List<File> jarFileOrDirList = HandleJarUtil.getJarFileOrDirList(jarOrDirPathArray, jarInfoMap);
        if (jarFileOrDirList == null) {
            return null;
        }
        File newJarFile = HandleJarUtil.getNewJarFile(jarFileOrDirList.get(0), jarOrDirPathArray[0]);
        if (newJarFile.exists()) {
            if (newJarFile.isDirectory()) {
                System.err.println("\u65b0\u7684jar\u5305\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u4f46\u662f\u662f\u76ee\u5f55: " + FileUtil.getCanonicalPath(newJarFile));
                return null;
            }
            if (!FileUtil.deleteFile(newJarFile)) {
                System.err.println("\u65b0\u7684jar\u5305\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u5220\u9664\u5931\u8d25: " + FileUtil.getCanonicalPath(newJarFile));
                return null;
            }
        }
        HashSet<String> destJarDirNameSet = new HashSet<String>(jarOrDirPathArray.length);
        ArrayList<File> jarFileInDirList = new ArrayList<File>();
        List<String> mergeClassInJarPackageList = HandleJarUtil.getMergeClassInJarPackageList();
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(newJarFile));){
            for (File jarFileOrDir : jarFileOrDirList) {
                String jarFileOrDirName = jarFileOrDir.getName();
                if (destJarDirNameSet.contains(jarFileOrDirName)) {
                    System.err.println("\u6307\u5b9a\u7684jar/war\u5305\u6216\u76ee\u5f55\u5b58\u5728\u540c\u540d\uff0c\u4e0d\u5904\u7406: " + jarFileOrDirName + " " + FileUtil.getCanonicalPath(jarFileOrDir));
                    continue;
                }
                destJarDirNameSet.add(jarFileOrDirName);
                if (jarFileOrDir.isFile()) {
                    HandleJarUtil.addJar2Jar(jarFileOrDir, zos, mergeClassInJarPackageList);
                    continue;
                }
                HandleJarUtil.addDir2Jar(jarFileOrDir, jarFileInDirList, zos);
            }
            for (File jarFileInDir : jarFileInDirList) {
                String jarFileName = jarFileInDir.getName();
                String jarCanonicalPath = FileUtil.getCanonicalPath(jarFileInDir);
                jarInfoMap.putIfAbsent(jarFileName, JarInfo.genJarInfo("J:", jarCanonicalPath));
                if (destJarDirNameSet.contains(jarFileName)) {
                    System.err.println("\u6307\u5b9a\u7684jar\u5305\u6216\u76ee\u5f55\u5b58\u5728\u540c\u540d\uff0c\u4e0d\u5904\u7406: " + jarFileName + " " + jarCanonicalPath);
                    continue;
                }
                destJarDirNameSet.add(jarFileName);
                System.out.println("\u6dfb\u52a0\u76ee\u5f55\u4e2d\u7684jar/war\u5305: " + jarCanonicalPath);
                HandleJarUtil.addJar2Jar(jarFileInDir, zos, mergeClassInJarPackageList);
            }
            String string = FileUtil.getCanonicalPath(newJarFile);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static List<File> getJarFileOrDirList(String[] jarOrDirPathArray, Map<String, JarInfo> jarInfoMap) {
        ArrayList<File> jarFileOrDirList = new ArrayList<File>(jarOrDirPathArray.length);
        for (String currentJarOrDirPath : jarOrDirPathArray) {
            File jarFileOrDir = new File(currentJarOrDirPath);
            String jarCanonicalPath = FileUtil.getCanonicalPath(jarFileOrDir);
            if (!jarFileOrDir.exists()) {
                System.err.println("\u6307\u5b9a\u7684jar\u5305\u6216\u76ee\u5f55\u4e0d\u5b58\u5728: " + jarCanonicalPath);
                return null;
            }
            jarFileOrDirList.add(jarFileOrDir);
            String jarOrDirType = jarFileOrDir.isFile() ? "J:" : "D:";
            jarInfoMap.putIfAbsent(jarFileOrDir.getName(), JarInfo.genJarInfo(jarOrDirType, jarCanonicalPath));
        }
        return jarFileOrDirList;
    }

    private static File getNewJarFile(File firstJarFile, String firstJarPath) {
        if (firstJarFile.isFile()) {
            return new File(firstJarPath + "-javacg_merged.jar");
        }
        return new File(firstJarPath + File.separator + firstJarFile.getName() + "-javacg_merged.jar");
    }

    private static void addJar2Jar(File sourceJarFile, ZipOutputStream targetZos, List<String> mergeClassInJarPackageList) throws IOException {
        String sourceJarName = sourceJarFile.getName();
        try (JarFile jar = new JarFile(sourceJarFile);){
            Enumeration<JarEntry> enumeration = jar.entries();
            while (enumeration.hasMoreElements()) {
                String jarEntryName;
                String jarEntryNameLower;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || !(jarEntryNameLower = (jarEntryName = jarEntry.getName()).toLowerCase()).endsWith(".class")) continue;
                if (!mergeClassInJarPackageList.isEmpty()) {
                    boolean classPackageMatches = false;
                    for (String mergeClassInJarPackage : mergeClassInJarPackageList) {
                        if (!jarEntryName.startsWith(mergeClassInJarPackage) && !jarEntryName.startsWith("WEB-INF/classes/" + mergeClassInJarPackage)) continue;
                        classPackageMatches = true;
                        JavaCGUtil.debugPrint("\u5f53\u524dclass\u6587\u4ef6\u5305\u540d\u5339\u914d\uff0c\u9700\u8981\u5408\u5e76 " + jarEntryName + " " + mergeClassInJarPackage);
                        break;
                    }
                    if (!classPackageMatches) {
                        JavaCGUtil.debugPrint("\u5f53\u524dclass\u6587\u4ef6\u5305\u540d\u4e0d\u5339\u914d\uff0c\u4e0d\u5408\u5e76 " + jarEntryName);
                        continue;
                    }
                }
                ZipEntry newZipEntry = new ZipEntry(sourceJarName + "/" + jarEntryName);
                targetZos.putNextEntry(newZipEntry);
                InputStream inputStream = jar.getInputStream(jarEntry);
                Throwable throwable = null;
                try {
                    HandleJarUtil.addInput2Jar(inputStream, targetZos);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
    }

    private static void addDir2Jar(File sourceDirFile, List<File> jarFileInDirList, ZipOutputStream targetZos) throws IOException {
        ArrayList<File> nonJarFileList = new ArrayList<File>();
        ArrayList<String> nonJarFileRelativelyPathList = new ArrayList<String>();
        HandleJarUtil.findFileInSubDir(sourceDirFile, null, nonJarFileList, nonJarFileRelativelyPathList, jarFileInDirList);
        if (nonJarFileList.isEmpty()) {
            return;
        }
        for (int i = 0; i < nonJarFileList.size(); ++i) {
            ZipEntry newZipEntry = new ZipEntry((String)nonJarFileRelativelyPathList.get(i));
            targetZos.putNextEntry(newZipEntry);
            try (FileInputStream inputStream = new FileInputStream((File)nonJarFileList.get(i));){
                HandleJarUtil.addInput2Jar(inputStream, targetZos);
                continue;
            }
        }
    }

    private static void findFileInSubDir(File dirFile, String dirPath, List<File> nonJarFileList, List<String> fileRelativelyPathList, List<File> jarFileInDirList) {
        File[] files = dirFile.listFiles();
        if (files == null) {
            return;
        }
        String dirPathHeader = dirPath == null ? dirFile.getName() : dirPath + "/" + dirFile.getName();
        for (File file : files) {
            if (file.isDirectory()) {
                HandleJarUtil.findFileInSubDir(file, dirPathHeader, nonJarFileList, fileRelativelyPathList, jarFileInDirList);
                continue;
            }
            String currentFileName = file.getName();
            String currentFileNameLower = currentFileName.toLowerCase();
            if (currentFileNameLower.endsWith(".jar") || currentFileNameLower.endsWith(".war")) {
                if (currentFileName.endsWith("-javacg_merged.jar")) continue;
                jarFileInDirList.add(file);
                continue;
            }
            if (currentFileName.contains("-javacg_merged.jar")) continue;
            nonJarFileList.add(file);
            fileRelativelyPathList.add(dirPathHeader + "/" + currentFileNameLower);
        }
    }

    private static void addInput2Jar(InputStream inputStream, ZipOutputStream targetZos) throws IOException {
        int len;
        byte[] data = new byte[4096];
        while ((len = inputStream.read(data)) > 0) {
            targetZos.write(data, 0, len);
        }
    }

    private HandleJarUtil() {
        throw new IllegalStateException("illegal");
    }
}

