/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.stat;

import com.adrninistrator.javacg.dto.CallIdCounter;
import com.adrninistrator.javacg.dto.MethodCallDto;
import com.adrninistrator.javacg.dto.MethodInfo;
import com.adrninistrator.javacg.enums.CallTypeEnum;
import com.adrninistrator.javacg.extensions.code_parser.CustomCodeParserInterface;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.BootstrapMethod;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.INVOKEDYNAMIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.Visitor;

public class MethodVisitor
extends EmptyVisitor {
    private static final String OTHER_METHOD_CALL_FORMAT = "M:%d %s:%s%s (%s)%s:%s";
    private JavaClass javaClass;
    private MethodGen mg;
    private ConstantPoolGen cpg;
    private String format;
    private List<MethodCallDto> methodCalls = new ArrayList<MethodCallDto>();
    private LineNumberTable lineNumberTable;
    private InstructionHandle ih;
    private Map<String, Set<String>> calleeMethodMapGlobal;
    private Map<String, Boolean> runnableImplClassMap;
    private Map<String, Boolean> callableImplClassMap;
    private Map<String, Boolean> threadChildClassMap;
    private CallIdCounter callIdCounter;
    private List<CustomCodeParserInterface> customCodeParserList;
    private boolean recordAll = false;
    private BufferedWriter annotationWriter;

    public MethodVisitor(MethodGen mg, JavaClass javaClass) {
        this.javaClass = javaClass;
        this.mg = mg;
        this.cpg = mg.getConstantPool();
        this.lineNumberTable = mg.getLineNumberTable(this.cpg);
    }

    public void setCalleeMethodMapGlobal(Map<String, Set<String>> calleeMethodMapGlobal) {
        this.calleeMethodMapGlobal = calleeMethodMapGlobal;
    }

    public void setRunnableImplClassMap(Map<String, Boolean> runnableImplClassMap) {
        this.runnableImplClassMap = runnableImplClassMap;
    }

    public void setCallableImplClassMap(Map<String, Boolean> callableImplClassMap) {
        this.callableImplClassMap = callableImplClassMap;
    }

    public void setThreadChildClassMap(Map<String, Boolean> threadChildClassMap) {
        this.threadChildClassMap = threadChildClassMap;
    }

    public void setCallIdCounter(CallIdCounter callIdCounter) {
        this.callIdCounter = callIdCounter;
    }

    public void setCustomCodeParserList(List<CustomCodeParserInterface> customCodeParserList) {
        this.customCodeParserList = customCodeParserList;
    }

    public void setRecordAll(boolean recordAll) {
        this.recordAll = recordAll;
    }

    public void setAnnotationWriter(BufferedWriter annotationWriter) {
        this.annotationWriter = annotationWriter;
    }

    public void beforeStart() {
        String fullMethod = this.javaClass.getClassName() + ":" + this.mg.getName() + JavaCGUtil.getArgListStr(this.mg.getArgumentTypes());
        JavaCGUtil.writeAnnotationInfo("M:", fullMethod, this.mg.getMethod().getAnnotationEntries(), this.annotationWriter);
        this.format = "M:%d " + fullMethod + " (%s)%s:%s%s";
    }

    public List<MethodCallDto> start() {
        if (this.mg.isAbstract() || this.mg.isNative()) {
            return Collections.emptyList();
        }
        this.ih = this.mg.getInstructionList().getStart();
        while (this.ih != null) {
            Instruction i = this.ih.getInstruction();
            if (i instanceof InvokeInstruction) {
                i.accept((Visitor)this);
            }
            this.ih = this.ih.getNext();
        }
        return this.methodCalls;
    }

    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL i) {
        this.addMethodCalls("M", i.getReferenceType(this.cpg).toString(), i.getMethodName(this.cpg), i.getArgumentTypes(this.cpg));
    }

    public void visitINVOKEINTERFACE(INVOKEINTERFACE i) {
        this.addMethodCalls("I", i.getReferenceType(this.cpg).toString(), i.getMethodName(this.cpg), i.getArgumentTypes(this.cpg));
    }

    public void visitINVOKESPECIAL(INVOKESPECIAL i) {
        this.addMethodCalls("O", i.getReferenceType(this.cpg).toString(), i.getMethodName(this.cpg), i.getArgumentTypes(this.cpg));
    }

    public void visitINVOKESTATIC(INVOKESTATIC i) {
        this.addMethodCalls("S", i.getReferenceType(this.cpg).toString(), i.getMethodName(this.cpg), i.getArgumentTypes(this.cpg));
    }

    public void visitINVOKEDYNAMIC(INVOKEDYNAMIC i) {
        this.addMethodCalls("D", i.getType(this.cpg).toString(), i.getMethodName(this.cpg), i.getArgumentTypes(this.cpg));
        Constant constant = this.cpg.getConstant(i.getIndex());
        if (!(constant instanceof ConstantInvokeDynamic)) {
            return;
        }
        ConstantInvokeDynamic cid = (ConstantInvokeDynamic)constant;
        BootstrapMethod bootstrapMethod = JavaCGUtil.getBootstrapMethod(this.javaClass, cid.getBootstrapMethodAttrIndex());
        if (bootstrapMethod == null) {
            System.err.println("### \u65e0\u6cd5\u627e\u5230bootstrapMethod " + this.javaClass.getClassName() + " " + cid.getBootstrapMethodAttrIndex());
            return;
        }
        MethodInfo bootstrapMethodInfo = JavaCGUtil.getBootstrapMethodInfo(bootstrapMethod, this.javaClass);
        if (bootstrapMethodInfo == null) {
            System.err.println("### \u65e0\u6cd5\u627e\u5230bootstrapMethod\u7684\u65b9\u6cd5\u4fe1\u606f " + this.javaClass.getClassName() + " " + bootstrapMethod);
            return;
        }
        String callType = bootstrapMethodInfo.getMethodName().startsWith("lambda$") ? CallTypeEnum.CTE_LM.getType() : CallTypeEnum.CTE_ST.getType();
        this.addMethodCalls(callType, bootstrapMethodInfo.getClassName(), bootstrapMethodInfo.getMethodName(), bootstrapMethodInfo.getMethodArgumentTypes());
    }

    private void addMethodCalls(String type, String calleeClassName, String calleeMethodName, Type[] arguments) {
        String calleeMethodArgs = JavaCGUtil.getArgListStr(arguments);
        if (!this.recordAll && !calleeClassName.startsWith("java.")) {
            Set calleeMethodWithArgsSet = this.calleeMethodMapGlobal.computeIfAbsent(calleeClassName, k -> new HashSet());
            calleeMethodWithArgsSet.add(calleeMethodName + calleeMethodArgs);
        }
        if (this.addMethodCall4Thread(calleeClassName, calleeMethodName, calleeMethodArgs)) {
            return;
        }
        int callId = this.callIdCounter.addAndGet();
        String methodCall = String.format(this.format, callId, type, calleeClassName, calleeMethodName, calleeMethodArgs);
        MethodCallDto methodCallDto = MethodCallDto.genInstance(methodCall, this.getSourceLine());
        this.methodCalls.add(methodCallDto);
        for (CustomCodeParserInterface customCodeParser : this.customCodeParserList) {
            customCodeParser.handleMethodCall(callId, calleeClassName, calleeMethodName, arguments, this.ih, this.mg);
        }
    }

    private boolean addMethodCall4Thread(String calleeClassName, String calleeMethodName, String calleeMethodArgs) {
        boolean skipRawMethodCall = false;
        if ("<init>".equals(calleeMethodName)) {
            Boolean recordedCallable;
            Boolean recordedRunnable = this.runnableImplClassMap.get(calleeClassName);
            if (recordedRunnable != null) {
                skipRawMethodCall = true;
                String methodCall = String.format(this.format, this.callIdCounter.addAndGet(), CallTypeEnum.CTE_RIR.getType(), calleeClassName, calleeMethodName, calleeMethodArgs);
                MethodCallDto methodCallDto1 = MethodCallDto.genInstance(methodCall, this.getSourceLine());
                this.methodCalls.add(methodCallDto1);
                if (Boolean.FALSE.equals(recordedRunnable)) {
                    String runnableImplClassMethod = String.format(OTHER_METHOD_CALL_FORMAT, this.callIdCounter.addAndGet(), calleeClassName, calleeMethodName, calleeMethodArgs, CallTypeEnum.CTE_RIR.getType(), calleeClassName, "run()");
                    MethodCallDto methodCallDto2 = MethodCallDto.genInstance(runnableImplClassMethod, 0);
                    this.methodCalls.add(methodCallDto2);
                    this.runnableImplClassMap.put(calleeClassName, Boolean.TRUE);
                }
            }
            if ((recordedCallable = this.callableImplClassMap.get(calleeClassName)) != null) {
                skipRawMethodCall = true;
                String methodCall = String.format(this.format, this.callIdCounter.addAndGet(), CallTypeEnum.CTE_CIC.getType(), calleeClassName, calleeMethodName, calleeMethodArgs);
                MethodCallDto methodCallDto1 = MethodCallDto.genInstance(methodCall, this.getSourceLine());
                this.methodCalls.add(methodCallDto1);
                if (Boolean.FALSE.equals(recordedCallable)) {
                    String callableImplClassMethod = String.format(OTHER_METHOD_CALL_FORMAT, this.callIdCounter.addAndGet(), calleeClassName, calleeMethodName, calleeMethodArgs, CallTypeEnum.CTE_CIC.getType(), calleeClassName, "call()");
                    MethodCallDto methodCallDto2 = MethodCallDto.genInstance(callableImplClassMethod, 0);
                    this.methodCalls.add(methodCallDto2);
                    this.callableImplClassMap.put(calleeClassName, Boolean.TRUE);
                }
            }
        } else if ("start".equals(calleeMethodName) && "()".equals(calleeMethodArgs) && Boolean.FALSE.equals(this.threadChildClassMap.get(calleeClassName))) {
            String threadChildClassMethod = String.format(OTHER_METHOD_CALL_FORMAT, this.callIdCounter.addAndGet(), calleeClassName, calleeMethodName, calleeMethodArgs, CallTypeEnum.CTE_TSR.getType(), calleeClassName, "run()");
            MethodCallDto methodCallDto2 = MethodCallDto.genInstance(threadChildClassMethod, 0);
            this.methodCalls.add(methodCallDto2);
            this.threadChildClassMap.put(calleeClassName, Boolean.TRUE);
        }
        return skipRawMethodCall;
    }

    private int getSourceLine() {
        if (this.lineNumberTable == null) {
            return 0;
        }
        int sourceLine = this.lineNumberTable.getSourceLine(this.ih.getPosition());
        return Math.max(sourceLine, 0);
    }
}

