/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.stat;

import com.adrninistrator.javacg.common.JavaCGConstants;
import com.adrninistrator.javacg.dto.CallIdCounter;
import com.adrninistrator.javacg.dto.MethodCallDto;
import com.adrninistrator.javacg.extensions.code_parser.CustomCodeParserInterface;
import com.adrninistrator.javacg.stat.MethodVisitor;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.MethodGen;

public class ClassVisitor {
    private JavaClass javaClass;
    private ConstantPoolGen cpg;
    private String classReferenceFormat;
    private List<MethodCallDto> methodCalls = new ArrayList<MethodCallDto>();
    private Map<String, Set<String>> calleeMethodMapGlobal;
    private Map<String, Boolean> runnableImplClassMap;
    private Map<String, Boolean> callableImplClassMap;
    private Map<String, Boolean> threadChildClassMap;
    private CallIdCounter callIdCounter;
    private List<CustomCodeParserInterface> customCodeParserList;
    private boolean recordAll = false;
    private BufferedWriter annotationWriter;

    public ClassVisitor(JavaClass javaClass) {
        this.javaClass = javaClass;
        this.cpg = new ConstantPoolGen(javaClass.getConstantPool());
        this.classReferenceFormat = "C:" + javaClass.getClassName() + " %s";
    }

    public void visitConstantPool() {
        ConstantPool constantPool = this.javaClass.getConstantPool();
        HashSet<String> referencedClassSet = new HashSet<String>();
        for (int i = 0; i < constantPool.getLength(); ++i) {
            Constant constant = constantPool.getConstant(i);
            if (constant == null || constant.getTag() != 7) continue;
            String referencedClass = constantPool.constantToString(constant);
            if (this.javaClass.getClassName().equals(referencedClass) || JavaCGConstants.OBJECT_CLASS_NAME.equals(referencedClass)) continue;
            referencedClass = JavaCGUtil.handleClassNameWithArray(referencedClass);
            referencedClassSet.add(referencedClass);
        }
        ArrayList referencedClassList = new ArrayList(referencedClassSet);
        Collections.sort(referencedClassList);
        for (String referencedClass : referencedClassList) {
            MethodCallDto methodCallDto = MethodCallDto.genInstance(String.format(this.classReferenceFormat, referencedClass), -1);
            this.methodCalls.add(methodCallDto);
        }
    }

    public void visitMethod(Method method) {
        try {
            MethodGen mg = new MethodGen(method, this.javaClass.getClassName(), this.cpg);
            MethodVisitor visitor = new MethodVisitor(mg, this.javaClass);
            visitor.setCalleeMethodMapGlobal(this.calleeMethodMapGlobal);
            visitor.setRunnableImplClassMap(this.runnableImplClassMap);
            visitor.setCallableImplClassMap(this.callableImplClassMap);
            visitor.setThreadChildClassMap(this.threadChildClassMap);
            visitor.setCallIdCounter(this.callIdCounter);
            visitor.setCustomCodeParserList(this.customCodeParserList);
            visitor.setRecordAll(this.recordAll);
            visitor.setAnnotationWriter(this.annotationWriter);
            visitor.beforeStart();
            List<MethodCallDto> methodCallDtos = visitor.start();
            this.methodCalls.addAll(methodCallDtos);
        }
        catch (Exception e) {
            System.err.println("\u5904\u7406\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38 " + this.javaClass.getClassName() + " " + method.getName());
            e.printStackTrace();
        }
    }

    public void start() {
        this.visitConstantPool();
        JavaCGUtil.writeAnnotationInfo("C:", this.javaClass.getClassName(), this.javaClass.getAnnotationEntries(), this.annotationWriter);
        for (Method method : this.javaClass.getMethods()) {
            this.visitMethod(method);
        }
    }

    public List<MethodCallDto> methodCalls() {
        return this.methodCalls;
    }

    public void setCalleeMethodMapGlobal(Map<String, Set<String>> calleeMethodMapGlobal) {
        this.calleeMethodMapGlobal = calleeMethodMapGlobal;
    }

    public void setRunnableImplClassMap(Map<String, Boolean> runnableImplClassMap) {
        this.runnableImplClassMap = runnableImplClassMap;
    }

    public void setCallableImplClassMap(Map<String, Boolean> callableImplClassMap) {
        this.callableImplClassMap = callableImplClassMap;
    }

    public void setThreadChildClassMap(Map<String, Boolean> threadChildClassMap) {
        this.threadChildClassMap = threadChildClassMap;
    }

    public void setCallIdCounter(CallIdCounter callIdCounter) {
        this.callIdCounter = callIdCounter;
    }

    public void setCustomCodeParserList(List<CustomCodeParserInterface> customCodeParserList) {
        this.customCodeParserList = customCodeParserList;
    }

    public void setRecordAll(boolean recordAll) {
        this.recordAll = recordAll;
    }

    public void setAnnotationWriter(BufferedWriter annotationWriter) {
        this.annotationWriter = annotationWriter;
    }
}

