/*
 * Decompiled with CFR 0.152.
 */
package com.github.generatecode.util;

import com.github.generatecode.out.SetGenerateConf;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JDBCUtils {
    private static Connection loadingDriverAndGetConnect() {
        SetGenerateConf setGenerateConf = SetGenerateConf.getInstance();
        String driver = setGenerateConf.getDriver();
        String url = setGenerateConf.getUrl();
        String user = setGenerateConf.getUser();
        String password = setGenerateConf.getPassword();
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.err.println("\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25\uff1a====" + e.getLocalizedMessage());
        }
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(url, user, password);
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.err.println("\u83b7\u53d6\u8fde\u63a5\u5931\u8d25\uff1a====" + e.getLocalizedMessage());
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> getData(String sql) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        ArrayList<Map<String, Object>> list;
        block6: {
            System.err.println(sql);
            list = new ArrayList<Map<String, Object>>();
            conn = null;
            stmt = null;
            rs = null;
            try {
                conn = JDBCUtils.loadingDriverAndGetConnect();
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                if (columnCount <= 0) break block6;
                while (rs.next()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (int i = 1; i <= columnCount; ++i) {
                        Object object = rs.getObject(i);
                        String columnName = metaData.getColumnName(i);
                        map.put(columnName, object);
                    }
                    list.add(map);
                }
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(rs, stmt, conn);
                    throw throwable;
                }
                JDBCUtils.close(rs, stmt, conn);
            }
        }
        JDBCUtils.close(rs, stmt, conn);
        return list;
    }

    public static void close(ResultSet rs, Statement stmt, Connection conn) {
        JDBCUtils.close(rs);
        JDBCUtils.close(stmt);
        JDBCUtils.close(conn);
    }

    public static void close(Connection conn) {
        if (null != conn) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(Statement stmt) {
        if (null != stmt) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

