/*
 * Decompiled with CFR 0.152.
 */
package com.github.generatecode.out;

import com.github.generatecode.model.FieldInfo;
import com.github.generatecode.model.MatchKeywordStartToEnd;
import com.github.generatecode.model.OutTableInfo;
import com.github.generatecode.model.TableInfo;
import com.github.generatecode.out.OutPipeFunction;
import com.github.generatecode.out.SetGenerateConf;
import com.github.generatecode.template.TypeCovert;
import com.github.generatecode.util.ClassUtil;
import com.github.generatecode.util.JDBCUtils;
import com.github.generatecode.util.RegexMatches;
import com.github.generatecode.util.StringUtils;
import com.github.generatecode.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class GenerateCode {
    private static Boolean isXmlVal = false;

    public static void generateCode() {
        SetGenerateConf instance = SetGenerateConf.getInstance();
        List<String> allFile = TextUtil.getAllFile(instance.getTemplateUrl(), false);
        List<OutTableInfo> tableList = GenerateCode.getTableOutInfo();
        List<TableInfo> tableInfoList = GenerateCode.getTableInfo(tableList);
        ArrayList<String> list = new ArrayList<String>();
        for (String path : allFile) {
            String[] reader = new String[]{TextUtil.readerStr(path)};
            GenerateCode.removeNote(reader);
            GenerateCode.tHbaseVar(reader);
            for (TableInfo table : tableInfoList) {
                String coperReader = reader[0];
                String[] isXML = (coperReader = GenerateCode.dealbaseInfo(coperReader, table)).split("#XML");
                if (isXML.length == 2) {
                    isXmlVal = true;
                    GenerateCode.generateXML(table, coperReader);
                    continue;
                }
                if (isXML.length < 2) {
                    isXmlVal = false;
                    GenerateCode.generateClass(table, coperReader);
                    continue;
                }
                String error = "XML\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff1a" + path + "|" + table.getTableName();
                System.err.println(error);
                list.add(error);
            }
            list.forEach(System.err::println);
        }
    }

    private static void generateClass(TableInfo table, String coperReader) {
        String[] packages = coperReader.split("package #defaultPackage;");
        String filesInfo = packages[0].trim();
        String fileName = GenerateCode.dealbaseInfoStartAndEnd(filesInfo, table, "#setFileName[", "]");
        String filePathSave = GenerateCode.dealbaseInfoStartAndEnd(filesInfo, table, "#setFilePath[", "]");
        boolean isAutoImport = filesInfo.contains("#autoImport");
        MatchKeywordStartToEnd packageAnaylsekey = RegexMatches.matchKeywordStartToEndFindoneRegexLimit1FromLetter("\\src\\main\\java\\", "", filePathSave);
        String convertPackage = StringUtils.convertPackage(filePathSave.substring(packageAnaylsekey.getEnd()));
        System.err.println("\u7531\u8def\u5f84\u89e3\u6790\u51fa\u4e86\u5305\u540d==============" + convertPackage);
        System.err.println(fileName + "=========================" + filePathSave);
        String packName = StringUtils.concat("package ", convertPackage, ";\n");
        String aPackage = packages[1];
        String content = StringUtils.concat(packName, aPackage);
        String replace = GenerateCode.getForeachMuch(table, content);
        if (isAutoImport) {
            for (int i = 0; i < table.getFieldInfos().size(); ++i) {
                FieldInfo fieldInfo = table.getFieldInfos().get(i);
                MatchKeywordStartToEnd autoImport = RegexMatches.matchKeywordStartToEndFindoneRegexLimit1FromLetter(StringUtils.concat("import ", fieldInfo.getClassType()), ";", replace);
                if (autoImport != null) continue;
                MatchKeywordStartToEnd packImport = RegexMatches.matchKeywordStartToEndFindoneRegexLimit1FromLetter("package ", ";", replace);
                replace = replace.replace(packImport.getKeywordFull(), StringUtils.concat(packImport.getKeywordFull(), "\n", "import ", fieldInfo.getClassType(), ";"));
            }
        }
        System.err.println(replace);
        TextUtil.write(filePathSave, fileName, replace);
    }

    private static void generateXML(TableInfo table, String coperReader) {
        String[] packages = coperReader.split("#XML");
        String filesInfo = packages[0].trim();
        String fileName = GenerateCode.dealbaseInfoStartAndEnd(filesInfo, table, "#setFileName[", "]");
        String filePathSave = GenerateCode.dealbaseInfoStartAndEnd(filesInfo, table, "#setFilePath[", "]");
        String content = packages[1];
        String replace = GenerateCode.getForeachMuch(table, content).trim();
        System.err.println(replace);
        TextUtil.write(filePathSave, fileName, replace);
    }

    private static String getForeachMuch(TableInfo table, String content) {
        MatchKeywordStartToEnd e = RegexMatches.matchKeywordStartToEndFindoneRegexLimit1("#foreach_start", "#foreach_end", content);
        if (e != null) {
            Map<String, Object> analyseArrayAndTmpValMap = GenerateCode.analyseArrayAndTmpVal(e, table);
            String toReplace = (String)analyseArrayAndTmpValMap.get("toReplace");
            content = content.replace(e.getKeywordFull(), toReplace);
            return GenerateCode.getForeachMuch(table, content);
        }
        return content;
    }

    private static void tHbaseVar(String[] reader) {
        Map<String, String> dynamicMap = SetGenerateConf.get_dynamic_map();
        for (Map.Entry<String, String> entry : dynamicMap.entrySet()) {
            String mapKey = entry.getKey();
            String mapValue = entry.getValue();
            reader[0] = reader[0].replace(mapKey, mapValue);
        }
    }

    private static Map<String, Object> analyseArrayAndTmpVal(MatchKeywordStartToEnd e, TableInfo table) {
        HashMap<String, Object> baseInfo = new HashMap<String, Object>();
        String tmpVarOut = "";
        String toReplace = "";
        List fieldInfos = new ArrayList();
        if (e != null) {
            MatchKeywordStartToEnd r;
            String keyword;
            block11: {
                keyword = e.getKeyword();
                r = RegexMatches.matchKeywordStartToEndFindoneRegexLimit1("(", ")", keyword);
                if (r != null) {
                    String kuohao = r.getKeyword();
                    String[] ins = kuohao.split(" in ");
                    if (ins.length != 2) {
                        try {
                            throw new Exception("#foreach \u540e\u9762\u7684\u683c\u5f0f\u4e0d\u89c4\u8303\uff01");
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            break block11;
                        }
                    }
                    String tmpVar = ins[0].trim();
                    tmpVarOut = tmpVar.replace("$", "");
                    String baseVar = ins[1].trim();
                    baseVar = baseVar.replace("$tableInfo.", "");
                    try {
                        fieldInfos = (List)ClassUtil.getPropertyValue(table, baseVar);
                        baseInfo.put("tmpVarOut", tmpVarOut);
                        baseInfo.put("fieldInfos", fieldInfos);
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            keyword = keyword.replace(r.getKeywordFull(), "");
            MatchKeywordStartToEnd rif = RegexMatches.matchKeywordStartToEndFindoneRegexLimit1(StringUtils.concat("$[", tmpVarOut, "."), "]", keyword);
            if (rif != null) {
                for (int i = 0; i < fieldInfos.size(); ++i) {
                    FieldInfo fieldInfo = (FieldInfo)fieldInfos.get(i);
                    try {
                        String tmpKeyword = keyword;
                        System.err.println(tmpKeyword);
                        String result = isXmlVal == false ? GenerateCode.anaylseForeachData(tmpVarOut, fieldInfo, tmpKeyword) : GenerateCode.anaylseForeachData(tmpVarOut, fieldInfo, tmpKeyword).trim() + "\n        ";
                        System.err.println(result);
                        System.err.println("--------------");
                        toReplace = StringUtils.concat(toReplace, result);
                        System.err.println(toReplace);
                        continue;
                    }
                    catch (IllegalAccessException ex) {
                        System.err.println("\u83b7\u53d6\u5b57\u6bb5\u5c5e\u6027\u62a5\u9519\uff1a" + keyword + "\u91cc\u9762\u7684" + rif.getKeyword());
                        ex.printStackTrace();
                    }
                }
            }
            toReplace = GenerateCode.dealIftrue(toReplace);
            toReplace = GenerateCode.dealIffalse(toReplace);
            baseInfo.put("toReplace", isXmlVal == false ? toReplace : toReplace.trim());
        }
        return baseInfo;
    }

    private static String dealIftrue(String toReplace) {
        MatchKeywordStartToEnd riftrue = RegexMatches.matchKeywordStartToEndFindoneRegexLimit1Specal("#if(true)", "#end", toReplace);
        if (riftrue == null) {
            return toReplace;
        }
        toReplace = toReplace.replace(riftrue.getKeywordFull(), riftrue.getKeyword());
        return GenerateCode.dealIftrue(toReplace);
    }

    private static String dealIffalse(String toReplace) {
        MatchKeywordStartToEnd rifalse = RegexMatches.matchKeywordStartToEndFindoneRegexLimit1Specal("#if(false)", "#end", toReplace);
        if (rifalse == null) {
            return toReplace;
        }
        toReplace = toReplace.replace(rifalse.getKeywordFull(), "");
        return GenerateCode.dealIffalse(toReplace);
    }

    private static String getOtherSplit(String keyword) {
        List<String> list = Arrays.asList(";", ")", "()");
        for (String s : list) {
            if (!keyword.contains(s)) continue;
            return s;
        }
        return null;
    }

    private static <T> String getPiPeSupport(T info, String tmpKeyword, MatchKeywordStartToEnd riff, String keyword) throws IllegalAccessException {
        String[] pipe = keyword.split("\\|");
        if (pipe.length >= 2) {
            Object propertyValue2 = ClassUtil.getPropertyValue(info, pipe[0]);
            for (int i = 1; i < pipe.length; ++i) {
                String func = pipe[i].trim();
                Function function = OutPipeFunction.PIPE_MAP.get(func);
                if (function == null) {
                    throw new IllegalAccessException("\u8be5\u7ba1\u9053\u7b26\u672a\u7533\u660e\uff0c\u8bf7\u4f7f\u7528\u6b63\u786e\u7684\u7ba1\u9053\u7b26\u6216\u8005\u5728OutPipeFunction\u4e2d\u81ea\u5b9a\u4e49\u7ba1\u9053\u7b26\uff1a" + func);
                }
                String propertyValue3 = (String)function.apply(propertyValue2);
                tmpKeyword = tmpKeyword.replace(riff.getKeywordFull(), propertyValue3);
            }
        } else {
            try {
                String propertyValue2 = (String)ClassUtil.getPropertyValue(info, keyword);
                propertyValue2 = StringUtils.isEmpty(propertyValue2) ? "\u6570\u636e\u5e93\u7f3a\u5c11\u5b57\u6bb5\u6ce8\u91ca" : propertyValue2;
                tmpKeyword = tmpKeyword.replace(riff.getKeywordFull(), propertyValue2);
            }
            catch (Exception e) {
                System.err.println(info + "\n" + keyword);
                e.printStackTrace();
                return null;
            }
        }
        return tmpKeyword;
    }

    private static String anaylseForeachData(String tmpVarOut, FieldInfo fieldInfo, String tmpKeyword) throws IllegalAccessException {
        MatchKeywordStartToEnd riff = RegexMatches.matchKeywordStartToEndFindoneRegexLimit1(StringUtils.concat("$[", tmpVarOut, "."), "]", tmpKeyword);
        if (riff != null) {
            String otherSplit = GenerateCode.getOtherSplit(riff.getKeyword());
            if (!StringUtils.isEmpty(otherSplit)) {
                riff.setKeyword(riff.getKeyword().replace(otherSplit, "").trim());
                String propertyValue2 = (String)ClassUtil.getPropertyValue(fieldInfo, riff.getKeyword());
                tmpKeyword = tmpKeyword.replace(riff.getKeywordFull(), propertyValue2 + otherSplit);
            } else {
                String keyword = riff.getKeyword();
                tmpKeyword = GenerateCode.getPiPeSupport(fieldInfo, tmpKeyword, riff, keyword);
            }
            System.err.println("tmpKeyword=============" + tmpKeyword);
            return GenerateCode.anaylseForeachData(tmpVarOut, fieldInfo, tmpKeyword);
        }
        return tmpKeyword;
    }

    private static void removeNote(String[] reader) {
        List<MatchKeywordStartToEnd> list = RegexMatches.matchKeywordStartToEnd(RegexMatches.escapeExprSpecialWord(SetGenerateConf.getNoteTemplateStart()), RegexMatches.escapeExprSpecialWord(SetGenerateConf.getNoteTemplateEnd()), reader[0]);
        if (list.size() > 0) {
            list.forEach(v -> {
                reader[0] = reader[0].replace(v.getKeywordFull(), "");
            });
        }
    }

    private static String dealbaseInfo(String reader, TableInfo table) {
        MatchKeywordStartToEnd key = RegexMatches.matchKeywordStartToEndFindoneRegexLimit1(SetGenerateConf.getDbTemplateStart(), SetGenerateConf.getDbTemplateEnd(), reader);
        if (key == null) {
            return reader;
        }
        String keyword = key.getKeyword();
        Object data = table;
        try {
            if (keyword.contains(StringUtils.concat("primaryKeyInfo", "."))) {
                keyword = keyword.replace(StringUtils.concat("primaryKeyInfo", "."), "").trim();
                data = ClassUtil.getPropertyValue(table, "primaryKeyInfo");
            }
            reader = GenerateCode.getPiPeSupport(data, reader, key, keyword);
            return GenerateCode.dealbaseInfo(reader, table);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            System.err.println("\u914d\u7f6e\u7684\u6a21\u677f\u4e2d\u6709\u672a\u8bc6\u522b\u7684\u53c2\u6570\u4fe1\u606f\uff1a\uff1a" + key.getKeywordFull());
            return reader;
        }
    }

    private static String dealbaseInfoStartAndEnd(String reader, TableInfo table, String start, String end) {
        MatchKeywordStartToEnd key = RegexMatches.matchKeywordStartToEndFindoneRegexLimit1(start, end, reader);
        String keyword = key.getKeyword();
        return keyword;
    }

    public static List<TableInfo> getTableInfoMock(List<OutTableInfo> tableList) {
        ArrayList<TableInfo> list = new ArrayList<TableInfo>();
        for (int i = 0; i < tableList.size(); ++i) {
            OutTableInfo v = tableList.get(i);
            TableInfo tableInfo = new TableInfo();
            String prefix = v.getPrefix();
            if (StringUtils.isEmpty(prefix)) {
                tableInfo.setCamelCaseTableName(StringUtils.getCamelCase(v.getTableName(), v.isCamelCase()));
            } else {
                String trim = v.getTableName().replace(prefix, "").trim();
                tableInfo.setCamelCaseTableName(StringUtils.getCamelCase(trim, v.isCamelCase()));
            }
            tableInfo.setCamelCase(v.isCamelCase());
            tableInfo.setTableName(v.getTableName());
            tableInfo.setTableNote("\u8868\u6ce8\u91ca\uff0c\u5f85\u89e3\u6790");
            tableInfo.setPrimaryKeyInfo(new FieldInfo("id", "\u4e3b\u952e", StringUtils.getCamelCase("id", false), "bigint", TypeCovert.getClassType("bigint"), TypeCovert.getClassTypeShort("bigint")));
            tableInfo.setAllSqlColumn("id,name,product_type");
            if (i % 2 == 0) {
                tableInfo.setFieldInfos(Arrays.asList(new FieldInfo("id", "\u4e3b\u952e", StringUtils.getCamelCase("id", false), "bigint", TypeCovert.getClassType("bigint"), TypeCovert.getClassTypeShort("bigint")), new FieldInfo("name", "\u59d3\u540d", StringUtils.getCamelCase("name", false), "char", TypeCovert.getClassType("char"), TypeCovert.getClassTypeShort("char")), new FieldInfo("product_type", "\u4ea7\u54c1\u7c7b\u578b", StringUtils.getCamelCase("product_type", false), "varchar", TypeCovert.getClassType("varchar"), TypeCovert.getClassTypeShort("varchar")), new FieldInfo("create_time", "\u65f6\u95f4", StringUtils.getCamelCase("create_time", false), "datetime", TypeCovert.getClassType("datetime"), TypeCovert.getClassTypeShort("datetime"))));
            } else {
                tableInfo.setFieldInfos(Arrays.asList(new FieldInfo("id1", "\u4e3b\u952e1", StringUtils.getCamelCase("id1", false), "bigint", TypeCovert.getClassType("bigint"), TypeCovert.getClassTypeShort("bigint")), new FieldInfo("name1", "\u59d3\u540d1", StringUtils.getCamelCase("name1", false), "char", TypeCovert.getClassType("char"), TypeCovert.getClassTypeShort("char")), new FieldInfo("product_type1", "\u4ea7\u54c1\u7c7b\u578b1", StringUtils.getCamelCase("product_type1", false), "varchar", TypeCovert.getClassType("varchar"), TypeCovert.getClassTypeShort("varchar")), new FieldInfo("create_time1", "\u65f6\u95f41", StringUtils.getCamelCase("create_time1", false), "datetime", TypeCovert.getClassType("datetime"), TypeCovert.getClassTypeShort("datetime"))));
            }
            list.add(tableInfo);
        }
        list.forEach(System.err::println);
        return list;
    }

    public static List<TableInfo> getTableInfo(List<OutTableInfo> tableList) {
        ArrayList<TableInfo> list = new ArrayList<TableInfo>();
        for (int i = 0; i < tableList.size(); ++i) {
            OutTableInfo v = tableList.get(i);
            TableInfo tableInfo = new TableInfo();
            String prefix = v.getPrefix();
            if (StringUtils.isEmpty(prefix)) {
                tableInfo.setCamelCaseTableName(StringUtils.getCamelCase(v.getTableName(), v.isCamelCase()));
            } else {
                String trim = v.getTableName().replace(prefix, "").trim();
                tableInfo.setCamelCaseTableName(StringUtils.getCamelCase(trim, v.isCamelCase()));
            }
            tableInfo.setCamelCase(v.isCamelCase());
            tableInfo.setTableName(v.getTableName());
            String dataBase = null;
            String url = SetGenerateConf.getInstance().getUrl();
            String[] split = url.split("\\?");
            if (split.length == 2) {
                String urls = split[0];
                int j = urls.lastIndexOf("/");
                dataBase = urls.substring(j + 1);
            }
            List<Map<String, Object>> dataTable = JDBCUtils.getData("SELECT * FROM information_schema.TABLES WHERE TABLE_SCHEMA = '" + dataBase + "' AND TABLE_NAME = '" + v.getTableName() + "'");
            tableInfo.setTableNote((String)dataTable.get(0).get("TABLE_COMMENT"));
            List<Map<String, Object>> dataColume = JDBCUtils.getData("SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = '" + dataBase + "' AND TABLE_NAME = '" + v.getTableName() + "'");
            StringBuilder strs = new StringBuilder();
            ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
            for (int i1 = 0; i1 < dataColume.size(); ++i1) {
                Map<String, Object> e = dataColume.get(i1);
                if (i1 == dataColume.size() - 1) {
                    strs.append(e.get("COLUMN_NAME"));
                    tableInfo.setAllSqlColumn(strs.toString());
                } else {
                    strs.append(e.get("COLUMN_NAME"));
                    strs.append(",");
                }
                String fieldName = (String)e.get("COLUMN_NAME");
                String fieldNote = (String)e.get("COLUMN_COMMENT");
                String fieldType = (String)e.get("COLUMN_TYPE");
                String fieldPriKey = (String)e.get("COLUMN_KEY");
                String fieldTypeNoNum = (String)e.get("DATA_TYPE");
                if ("PRI".equals(fieldPriKey)) {
                    tableInfo.setPrimaryKeyInfo(new FieldInfo(fieldName, fieldNote, StringUtils.getCamelCase(fieldName, false), fieldType, TypeCovert.getClassType(fieldType), TypeCovert.getClassTypeShort(fieldType), fieldTypeNoNum, true));
                    fieldInfos.add(new FieldInfo(fieldName, fieldNote, StringUtils.getCamelCase(fieldName, false), fieldType, TypeCovert.getClassType(fieldType), TypeCovert.getClassTypeShort(fieldType), fieldTypeNoNum, true));
                    continue;
                }
                fieldInfos.add(new FieldInfo(fieldName, fieldNote, StringUtils.getCamelCase(fieldName, false), fieldType, TypeCovert.getClassType(fieldType), TypeCovert.getClassTypeShort(fieldType), fieldTypeNoNum, false));
            }
            tableInfo.setFieldInfos(fieldInfos);
            list.add(tableInfo);
        }
        list.forEach(System.err::println);
        return list;
    }

    public static List<OutTableInfo> getTableOutInfoMock() {
        List<OutTableInfo> list = Arrays.asList(new OutTableInfo("t_s_user"), new OutTableInfo("t_s_order", "t_s_"), new OutTableInfo("t_s_order_mmp", "t_s_", true));
        return list;
    }

    public static List<OutTableInfo> getTableOutInfo() {
        List<OutTableInfo> list = SetGenerateConf.getInstance().getTableList();
        return list;
    }
}

