/*
 * Decompiled with CFR 0.152.
 */
package serendip.struts.plugins.thymeleaf.spring;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.context.ApplicationContext;
import org.thymeleaf.context.AbstractContext;
import org.thymeleaf.context.IWebContext;
import serendip.struts.plugins.thymeleaf.spring.Beans;

public class SpringWebContext
extends AbstractContext
implements IWebContext {
    public static final String BEANS_VARIABLE_NAME = "beans";
    private static final ConcurrentHashMap<ApplicationContext, HashMap<String, Object>> variableMapPrototypes = new ConcurrentHashMap();
    private final ApplicationContext applicationContext;
    private final HttpServletRequest httpServletRequest;
    private final HttpServletResponse httpServletResponse;
    private final ServletContext servletContext;

    public SpringWebContext(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Locale locale, Map<String, ?> variables, ApplicationContext appctx) {
        super(locale, SpringWebContext.addSpringSpecificVariables(variables, appctx));
        this.httpServletRequest = request;
        this.httpServletResponse = response;
        this.servletContext = servletContext;
        this.applicationContext = appctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> addSpringSpecificVariables(Map<String, ?> variables, ApplicationContext appctx) {
        Map newVariables;
        HashMap<String, Object> variableMapPrototype = variableMapPrototypes.get(appctx);
        if (variableMapPrototype == null) {
            variableMapPrototype = new HashMap(20, 1.0f);
            Beans beans = new Beans(appctx);
            variableMapPrototype.put(BEANS_VARIABLE_NAME, beans);
            variableMapPrototypes.put(appctx, variableMapPrototype);
        }
        HashMap<String, Object> hashMap = variableMapPrototype;
        synchronized (hashMap) {
            newVariables = (Map)variableMapPrototype.clone();
        }
        if (variables != null) {
            newVariables.putAll(variables);
        }
        return newVariables;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public HttpServletRequest getRequest() {
        return this.httpServletRequest;
    }

    public HttpServletResponse getResponse() {
        return this.httpServletResponse;
    }

    public HttpSession getSession() {
        return this.httpServletRequest.getSession(false);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

