/*
 * Decompiled with CFR 0.152.
 */
package serendip.struts.plugins.thymeleaf.spi;

import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.Dispatcher;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.ServletContextTemplateResolver;
import serendip.struts.plugins.thymeleaf.diarect.FieldDialect;
import serendip.struts.plugins.thymeleaf.spi.TemplateEngineProvider;

public class DefaultTemplateEngineProvider
implements TemplateEngineProvider {
    private String templateMode = "HTML5";
    private String characterEncoding = "UTF-8";
    private String prefix = "/WEB-INF/templates/";
    private String suffix = ".html";
    private boolean cacheable = true;
    private Long cacheTtlMillis = 3600000L;
    protected TemplateEngine templateEngine;
    private String templateEngineName = "default";
    private Container container;
    private Map<String, TemplateEngine> templateEngines = new HashMap<String, TemplateEngine>();

    public void configure() {
        ServletContext servletContext = ServletActionContext.getServletContext();
        ServletContextTemplateResolver templateResolver = new ServletContextTemplateResolver(servletContext);
        templateResolver.setTemplateMode(this.templateMode);
        templateResolver.setCharacterEncoding(this.characterEncoding);
        templateResolver.setPrefix(this.prefix);
        templateResolver.setSuffix(this.suffix);
        templateResolver.setCacheable(this.cacheable);
        templateResolver.setCacheTTLMs(this.cacheTtlMillis);
        this.templateEngine.setTemplateResolver((ITemplateResolver)templateResolver);
        FieldDialect fieldDialect = new FieldDialect(TemplateMode.HTML, "sth");
        this.templateEngine.addDialect((IDialect)fieldDialect);
    }

    @Override
    public TemplateEngine get() {
        if (this.templateEngine == null) {
            Container container = Dispatcher.getInstance().getContainer();
            this.setContainer(container);
            this.templateEngine = this.templateEngines.get(this.templateEngineName);
            this.configure();
        }
        return this.templateEngine;
    }

    @Inject(value="struts.thymeleaf.templateMode", required=false)
    public void setTemplateMode(String templateMode) {
        this.templateMode = templateMode;
    }

    @Inject(value="struts.thymeleaf.encoding", required=false)
    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    @Inject(value="struts.thymeleaf.prefix", required=false)
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Inject(value="struts.thymeleaf.suffix", required=false)
    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Inject(value="struts.thymeleaf.cacheable", required=false)
    public void setCacheable(String cacheable) {
        this.cacheable = Boolean.parseBoolean(cacheable);
    }

    @Inject(value="struts.thymeleaf.cacheTtlMillis", required=false)
    public void setCacheTtlMillis(String cacheTtlMillis) {
        this.cacheTtlMillis = Long.parseLong(cacheTtlMillis);
    }

    public void setContainer(Container container) {
        this.container = container;
        HashMap<String, TemplateEngine> map = new HashMap<String, TemplateEngine>();
        Set prefixes = container.getInstanceNames(TemplateEngine.class);
        for (String prefix : prefixes) {
            TemplateEngine engine = (TemplateEngine)container.getInstance(TemplateEngine.class, prefix);
            map.put(prefix, engine);
        }
        this.templateEngines = Collections.unmodifiableMap(map);
    }

    @Inject(value="struts.thymeleaf.templateEngineName")
    public void setTemplateEngineName(String templateEngineName) {
        this.templateEngineName = templateEngineName;
    }
}

