/*
 * Decompiled with CFR 0.152.
 */
package serendip.struts.plugins.thymeleaf.diarect;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IAttribute;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.TemplateMode;
import org.unbescape.html.HtmlEscape;

public class FieldErrorAttributeProcessor
extends AbstractAttributeTagProcessor {
    private static final String ATTR_NAME = "value";
    private static final int PRECEDENCE = 1010;

    public FieldErrorAttributeProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, null, false, ATTR_NAME, true, 1010, true);
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        IEngineConfiguration configuration = context.getConfiguration();
        IStandardExpressionParser parser = StandardExpressions.getExpressionParser((IEngineConfiguration)configuration);
        String fieldname = tag.getAttributeValue(null, "name");
        Object parameterValue = this.getFieldValue(fieldname);
        if (parameterValue != null) {
            structureHandler.setAttribute(ATTR_NAME, HtmlEscape.escapeHtml5((String)parameterValue.toString()));
        }
        if (!this.hasFieldError(fieldname)) {
            return;
        }
        IAttribute cssClass = tag.getAttribute("class");
        String css = cssClass.getValue();
        if (StringUtils.isBlank((CharSequence)css)) {
            structureHandler.setAttribute("class", this.fieldErrorClass(tag));
        } else {
            structureHandler.setAttribute("class", this.fieldErrorClass(tag) + " " + css);
        }
    }

    protected boolean hasFieldError(String fieldname) {
        if (StringUtils.isEmpty((CharSequence)fieldname)) {
            return false;
        }
        Object action = ActionContext.getContext().getActionInvocation().getAction();
        if (!(action instanceof ActionSupport)) {
            return false;
        }
        ActionSupport asupport = (ActionSupport)action;
        Map fieldErrors = asupport.getFieldErrors();
        return fieldErrors != null && fieldErrors.size() != 0;
    }

    protected Object getFieldValue(String fieldname) {
        ActionContext actionCtx = ActionContext.getContext();
        ValueStack valueStack = actionCtx.getValueStack();
        Object value = valueStack.findValue(fieldname, false);
        String overwriteValue = this.getOverwriteValue(fieldname);
        if (overwriteValue != null) {
            return overwriteValue;
        }
        return value;
    }

    protected String fieldErrorClass(IProcessableElementTag tag) {
        if (tag.getAttribute("error-css") == null) {
            return "field-error";
        }
        String css = tag.getAttribute("error-css").getValue();
        return css;
    }

    protected String getOverwriteValue(String fieldname) {
        ActionContext ctx = ServletActionContext.getContext();
        ValueStack stack = ctx.getValueStack();
        Map overrideMap = stack.getExprOverrides();
        if (overrideMap == null || overrideMap.isEmpty()) {
            return null;
        }
        if (!overrideMap.containsKey(fieldname)) {
            return null;
        }
        String convertionValue = (String)overrideMap.get(fieldname);
        String altString = StringEscapeUtils.unescapeJava((String)convertionValue);
        altString = altString.substring(1, altString.length() - 1);
        return altString;
    }
}

