/*
 * Decompiled with CFR 0.152.
 */
package serendip.struts.plugins.thymeleaf;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.inject.Inject;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import serendip.struts.plugins.thymeleaf.spi.TemplateEngineProvider;
import serendip.struts.plugins.thymeleaf.spring.SpringWebContext;

public class ThymeleafSpringResult
implements Result {
    private String defaultEncoding = "UTF-8";
    private TemplateEngineProvider templateEngineProvider;
    private String templateName;
    public static final String DEFAULT_PARAM = "templateName";
    public static final String ACTION_VARIABLE_NAME = "action";
    public static final String FIELD_ERRORS_NAME = "field";
    public static final String OVERRIDES_NAME = "overrides";

    public ThymeleafSpringResult() {
    }

    public ThymeleafSpringResult(String templateName) {
        this.templateName = templateName;
    }

    public void execute(ActionInvocation actionInvocation) throws Exception {
        TemplateEngine templateEngine = this.templateEngineProvider.get();
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        ServletContext servletContext = ServletActionContext.getServletContext();
        Object action = actionInvocation.getAction();
        Map<String, Object> variables = this.bindStrutsContext(action);
        Locale locale = ((LocaleProvider)action).getLocale();
        ApplicationContext appctx = (ApplicationContext)servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        SpringWebContext context = new SpringWebContext(request, response, servletContext, locale, variables, appctx);
        response.setContentType("text/html");
        response.setCharacterEncoding(this.defaultEncoding);
        templateEngine.process(this.templateName, (IContext)context, (Writer)response.getWriter());
    }

    @Inject(value="struts.i18n.encoding")
    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    @Inject
    public void setTemplateEngineProvider(TemplateEngineProvider templateEngineProvider) {
        this.templateEngineProvider = templateEngineProvider;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    Map<String, Object> bindStrutsContext(Object action) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(ACTION_VARIABLE_NAME, action);
        if (action instanceof ActionSupport) {
            ActionSupport actSupport = (ActionSupport)action;
            Map fieldErrors = actSupport.getFieldErrors();
            variables.put(FIELD_ERRORS_NAME, fieldErrors);
        }
        return variables;
    }
}

