/*
 * Decompiled with CFR 0.152.
 */
package serendip.struts.plugins.thymeleaf;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.inject.Inject;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import serendip.struts.plugins.thymeleaf.StrutsContext;
import serendip.struts.plugins.thymeleaf.spi.TemplateEngineProvider;

public class ThymeleafResult
implements Result {
    private String defaultEncoding = "UTF-8";
    private TemplateEngineProvider templateEngineProvider;
    private String templateName;
    public static final String DEFAULT_PARAM = "templateName";
    public static final String ACTION_VARIABLE_NAME = "action";
    public static final String FIELD_ERRORS_NAME = "field";
    public static final String OVERRIDES_NAME = "overrides";

    public ThymeleafResult() {
    }

    public ThymeleafResult(String templateName) {
        this.templateName = templateName;
    }

    public void execute(ActionInvocation actionInvocation) throws Exception {
        TemplateEngine templateEngine = this.templateEngineProvider.get();
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        ServletContext servletContext = ServletActionContext.getServletContext();
        Object action = actionInvocation.getAction();
        Map<String, Object> variables = this.bindStrutsContext(action);
        Locale locale = null;
        if (action instanceof LocaleProvider) {
            locale = ((LocaleProvider)action).getLocale();
        }
        StrutsContext context = new StrutsContext(request, response, servletContext, locale, variables);
        response.setContentType("text/html");
        response.setCharacterEncoding(this.defaultEncoding);
        templateEngine.process(this.templateName, (IContext)context, (Writer)response.getWriter());
    }

    @Inject(value="struts.i18n.encoding")
    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    @Inject
    public void setTemplateEngineProvider(TemplateEngineProvider templateEngineProvider) {
        this.templateEngineProvider = templateEngineProvider;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    Map<String, Object> bindStrutsContext(Object action) {
        ConcurrentHashMap<String, Object> variables = new ConcurrentHashMap<String, Object>();
        variables.put(ACTION_VARIABLE_NAME, action);
        if (action instanceof ActionSupport) {
            ActionSupport actSupport = (ActionSupport)action;
            Map fieldErrors = actSupport.getFieldErrors();
            variables.put(FIELD_ERRORS_NAME, fieldErrors);
        }
        return variables;
    }
}

