/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.utility.asynchronous;

import org.apache.log4j.MDC;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;

public class MonoCallSynchronousExecutor {
    private static final Logger log = LogManager.getLogger(MonoCallSynchronousExecutor.class);
    private static final int THRESHOLD_SECONDS = 5;

    private static Thread getHelperThread(final Disposable disposable, final String descriptor, final long perodicCheckMilliSecondsTime) {
        Object requestId = MDC.get((String)"requestId");
        final String id = null != requestId ? (String)requestId : "";
        Thread helperThread = new Thread(){

            private void checkThresholdCrossed(int sleptTimes, long perodicCheckMilliSeconds) {
                boolean isThresholdLimitReached;
                long sleptDurationInMilliSeconds = (long)sleptTimes * perodicCheckMilliSeconds;
                int sleptDurationInSeconds = (int)sleptDurationInMilliSeconds / 1000;
                long milliSecondOffset = sleptDurationInMilliSeconds - (long)(sleptDurationInSeconds * 1000);
                boolean isSleptSecondsMultiplierOfThreshold = 0 == sleptDurationInSeconds % 5;
                boolean bl = isThresholdLimitReached = isSleptSecondsMultiplierOfThreshold && 0L == milliSecondOffset;
                if (sleptDurationInSeconds > 0 && isThresholdLimitReached) {
                    log.warn("{} -> (disposed) {} (eachSleepMilliSecondDuration) {} (sleptTimes) {} (sleptDurationInSeconds) {}", (Object)descriptor, (Object)false, (Object)perodicCheckMilliSeconds, (Object)sleptTimes, (Object)sleptDurationInSeconds);
                } else {
                    log.debug("{} -> (disposed) {} (eachSleepMilliSecondDuration) {} (sleptTimes) {}", (Object)descriptor, (Object)false, (Object)perodicCheckMilliSeconds, (Object)sleptTimes);
                }
            }

            @Override
            public void run() {
                MDC.put((String)"requestId", (String)id);
                boolean disposed = false;
                int sleptTimes = 0;
                while (!(disposed = disposable.isDisposed())) {
                    try {
                        1.sleep(perodicCheckMilliSecondsTime);
                    }
                    catch (InterruptedException e) {
                        log.error("InterruptedException -> {}", (Object)e.getMessage(), (Object)e);
                        break;
                    }
                    this.checkThresholdCrossed(++sleptTimes, perodicCheckMilliSecondsTime);
                }
                log.debug("{} -> (disposed) {}", (Object)descriptor, (Object)disposed);
            }
        };
        helperThread.setName("ThreadHelper - " + descriptor);
        return helperThread;
    }

    public static <T> Thread waitForIt(Mono<T> monoCall, String descriptor, long sleepMilliSeconds) {
        Disposable disposable = monoCall.subscribe();
        Thread helperThread = MonoCallSynchronousExecutor.getHelperThread(disposable, descriptor, sleepMilliSeconds);
        helperThread.start();
        return helperThread;
    }
}

