/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.service;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import open.source.exchange.entity.ExApplicationContext;
import open.source.exchange.enumeration.ExchangeInformationType;
import open.source.exchange.model.ExLocaleContext;
import open.source.exchange.model.ExMultiValueMap;
import open.source.exchange.model.ExPrincipal;
import open.source.exchange.model.ExServerHttpResponse;
import open.source.exchange.model.ExWebSession;
import open.source.exchange.parser.ApplicationContextParser;
import open.source.exchange.parser.LocaleContextParser;
import open.source.exchange.parser.MultiValueMapParser;
import open.source.exchange.parser.PartParser;
import open.source.exchange.parser.PrincipalParser;
import open.source.exchange.parser.ServerHttpRequestParser;
import open.source.exchange.parser.ServerHttpResponseParser;
import open.source.exchange.parser.WebSessionParser;
import open.source.exchange.repository.asynchronous.ExApplicationContextRepoAsync;
import open.source.exchange.repository.asynchronous.InformationExchangeRepoAsync;
import open.source.exchange.utility.asynchronous.MonoCallSynchronousExecutor;
import org.apache.log4j.MDC;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

@Service
public class ParserHelper {
    private static final Logger log = LogManager.getLogger(ParserHelper.class);
    @Autowired
    private ApplicationContextParser applicationContextParser;
    @Autowired
    private LocaleContextParser localeContextParser;
    @Autowired
    private ServerHttpRequestParser serverHttpRequestParser;
    @Autowired
    private PrincipalParser principalParser;
    @Autowired
    private WebSessionParser webSessionParser;
    @Autowired
    private MultiValueMapParser multiValueMapParser;
    @Autowired
    private PartParser partParser;
    @Autowired
    private ServerHttpResponseParser serverHttpResponseParser;
    @Autowired
    private ExApplicationContextRepoAsync exApplicationContextRepoAsync;
    @Autowired
    private InformationExchangeRepoAsync informationExchangeRepoAsync;
    private static boolean APPLICATION_CONTEXT_PERSISTED_FLAG = false;

    private String identifier() {
        return (String)MDC.get((String)"identifier");
    }

    public void identifyAndPersist(ServerWebExchange serverWebExchange, ExchangeInformationType exchangeInformationType) {
        String identifier = this.identifier();
        log.debug("identify and persist -> (identifier) {} (exchangeInformationType) {}", (Object)identifier, (Object)exchangeInformationType);
        Mono monoCall = null;
        switch (exchangeInformationType) {
            case attributes: {
                Map attributes = serverWebExchange.getAttributes();
                monoCall = this.informationExchangeRepoAsync.updateAttribute(identifier, exchangeInformationType.name(), attributes);
                break;
            }
            case logPrefix: {
                String logPrefix = serverWebExchange.getLogPrefix();
                monoCall = this.informationExchangeRepoAsync.updateAttribute(identifier, exchangeInformationType.name(), logPrefix);
                break;
            }
            case notModifiedFlag: {
                boolean notModifiedFlag = serverWebExchange.isNotModified();
                monoCall = this.informationExchangeRepoAsync.updateAttribute(identifier, exchangeInformationType.name(), notModifiedFlag);
                break;
            }
            case serverHttpRequest: {
                ServerHttpRequest request = serverWebExchange.getRequest();
                monoCall = this.serverHttpRequestParser.parse(request).flatMap(exServerHttpRequest -> {
                    log.trace("got -> (exServerHttpRequest) {}", exServerHttpRequest);
                    return this.informationExchangeRepoAsync.updateAttribute(identifier, exchangeInformationType.name(), exServerHttpRequest);
                });
                break;
            }
            case principal: {
                monoCall = serverWebExchange.getPrincipal().flux().collectList().flatMap(principalList -> {
                    log.trace("got -> (principalList) {}", principalList);
                    Principal principal = principalList.isEmpty() ? null : (Principal)principalList.get(0);
                    ExPrincipal exPrincipal = this.principalParser.parse(principal);
                    return this.informationExchangeRepoAsync.updateAttribute(identifier, exchangeInformationType.name(), exPrincipal);
                });
                break;
            }
            case session: {
                monoCall = serverWebExchange.getSession().flux().collectList().flatMap(sessionList -> {
                    log.trace("got -> (sessionList) {}", sessionList);
                    WebSession session = sessionList.isEmpty() ? null : (WebSession)sessionList.get(0);
                    ExWebSession exSession = this.webSessionParser.parse(session);
                    return this.informationExchangeRepoAsync.updateAttribute(identifier, exchangeInformationType.name(), exSession);
                });
                break;
            }
            case formData: {
                monoCall = serverWebExchange.getFormData().flux().collectList().flatMap(formDataList -> {
                    log.trace("got -> (formDataList) {}", formDataList);
                    MultiValueMap formData = formDataList.isEmpty() ? null : (MultiValueMap)formDataList.get(0);
                    ExMultiValueMap exFormData = this.multiValueMapParser.parse(formData);
                    return this.informationExchangeRepoAsync.updateAttribute(identifier, exchangeInformationType.name(), exFormData);
                });
                break;
            }
            case multipartData: {
                monoCall = serverWebExchange.getMultipartData().flux().collectList().flatMap(multipartDataList -> {
                    log.trace("got -> (multipartDataList) {}", multipartDataList);
                    MultiValueMap multipartData = multipartDataList.isEmpty() ? null : (MultiValueMap)multipartDataList.get(0);
                    ExMultiValueMap exMultiValueMap = this.multiValueMapParser.parse(multipartData);
                    if (null != exMultiValueMap) {
                        ExMultiValueMap exParts = new ExMultiValueMap();
                        exParts.setClazz(exMultiValueMap.getClazz());
                        exParts.setHashCode(exMultiValueMap.getHashCode());
                        exParts.setToString(exMultiValueMap.getToString());
                        exParts.setSize(exMultiValueMap.getSize());
                        exParts.setEmpty(exMultiValueMap.isEmpty());
                        Map mapVsList = exMultiValueMap.getMapVsList();
                        TreeMap mapVsExList = null;
                        if (null != mapVsList) {
                            mapVsExList = new TreeMap();
                            for (String key : mapVsList.keySet()) {
                                List values = mapVsList.get(key);
                                int size = null != values ? values.size() : 1;
                                ArrayList exValueList = new ArrayList(size);
                                if (null != values) {
                                    int index = 0;
                                    for (Part part : values) {
                                        Mono exPartMono = this.partParser.parse(part).map(exPart -> {
                                            exValueList.add(exPart);
                                            return exPart;
                                        });
                                        Thread helperThread = MonoCallSynchronousExecutor.waitForIt(exPartMono, "get part data for key: " + key + " index: " + index, 10L);
                                        ++index;
                                    }
                                }
                                mapVsExList.put(key, exValueList);
                            }
                        }
                        exParts.setMapVsList(mapVsExList);
                        return this.informationExchangeRepoAsync.updateAttribute(identifier, exchangeInformationType.name(), exParts);
                    }
                    return Mono.just((Object)false);
                });
                break;
            }
            case localeContext: {
                LocaleContext localeContext = serverWebExchange.getLocaleContext();
                ExLocaleContext exLocaleContext = this.localeContextParser.parse(localeContext);
                monoCall = this.informationExchangeRepoAsync.updateAttribute(identifier, exchangeInformationType.name(), exLocaleContext);
                break;
            }
            case serverHttpResponse: {
                ServerHttpResponse response = serverWebExchange.getResponse();
                ExServerHttpResponse exServerHttpResponse = this.serverHttpResponseParser.parse(response);
                monoCall = this.informationExchangeRepoAsync.updateAttribute(identifier, exchangeInformationType.name(), exServerHttpResponse);
                break;
            }
            case applicationContext: {
                if (APPLICATION_CONTEXT_PERSISTED_FLAG) {
                    monoCall = Mono.just((Object)false);
                    break;
                }
                APPLICATION_CONTEXT_PERSISTED_FLAG = true;
                ApplicationContext applicationContext = serverWebExchange.getApplicationContext();
                ExApplicationContext exApplicationContext = this.applicationContextParser.parse(applicationContext);
                String documentId = exApplicationContext.getEnvironment().getActiveProfiles()[0] + "-" + exApplicationContext.getStartupDate();
                exApplicationContext.setDocumentId(documentId);
                monoCall = this.exApplicationContextRepoAsync.insert(exApplicationContext).flatMap(persistedExApplicationContext -> {
                    log.debug("persisted -> (exApplicationContext) {}", persistedExApplicationContext);
                    return Mono.just((Object)true);
                });
                break;
            }
        }
        Thread helperThread = MonoCallSynchronousExecutor.waitForIt(monoCall, "web exchange update " + exchangeInformationType.name(), 50L);
    }
}

