/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.service;

import java.util.Map;
import open.source.exchange.entity.InformationExchange;
import open.source.exchange.enumeration.ExchangeInformationType;
import open.source.exchange.enumeration.TimeEvent;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExEnum;
import open.source.exchange.model.Time;
import open.source.exchange.parser.EnumParser;
import open.source.exchange.parser.ObjectParser;
import open.source.exchange.repository.asynchronous.InformationExchangeRepoAsync;
import open.source.exchange.service.ParserHelper;
import open.source.exchange.utility.asynchronous.MonoCallSynchronousExecutor;
import org.apache.log4j.MDC;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

@Service
public class InformationExchangeService {
    private static final Logger log = LogManager.getLogger(InformationExchangeService.class);
    @Autowired
    private ObjectParser objectParser;
    @Autowired
    private EnumParser enumParser;
    @Autowired
    private ParserHelper parserHelper;
    @Autowired
    private InformationExchangeRepoAsync informationExchangeRepoAsync;

    public void onEntry(long startTimestamp, ServerWebExchange serverWebExchange, String identifier) {
        String requestId = serverWebExchange.getRequest().getId();
        log.trace("on entry -> (requestId) {} (startTimestamp) {} (identifier) {}", (Object)requestId, (Object)startTimestamp, (Object)identifier);
        ExBase exBase = this.objectParser.parse(serverWebExchange);
        InformationExchange informationExchange = new InformationExchange(exBase);
        informationExchange.setId(identifier);
        Mono monoCall = this.informationExchangeRepoAsync.insert(informationExchange).flatMap(persistedInformationExchange -> {
            MDC.put((String)"requestId", (String)requestId);
            MDC.put((String)"identifier", (String)identifier);
            log.info("created entry of api call -> (requestId) {} (informationExchangeId) {}", (Object)requestId, (Object)identifier);
            log.debug("persisted -> (informationExchange) {}", persistedInformationExchange);
            this.parserHelper.identifyAndPersist(serverWebExchange, ExchangeInformationType.attributes);
            this.parserHelper.identifyAndPersist(serverWebExchange, ExchangeInformationType.logPrefix);
            this.parserHelper.identifyAndPersist(serverWebExchange, ExchangeInformationType.notModifiedFlag);
            this.parserHelper.identifyAndPersist(serverWebExchange, ExchangeInformationType.serverHttpRequest);
            this.parserHelper.identifyAndPersist(serverWebExchange, ExchangeInformationType.principal);
            this.parserHelper.identifyAndPersist(serverWebExchange, ExchangeInformationType.session);
            this.parserHelper.identifyAndPersist(serverWebExchange, ExchangeInformationType.formData);
            this.parserHelper.identifyAndPersist(serverWebExchange, ExchangeInformationType.multipartData);
            this.parserHelper.identifyAndPersist(serverWebExchange, ExchangeInformationType.localeContext);
            return Mono.just((Object)persistedInformationExchange);
        });
        Thread helperThread = MonoCallSynchronousExecutor.waitForIt(monoCall, "server web exchange at entry", 50L);
        try {
            helperThread.join();
        }
        catch (InterruptedException e) {
            log.error("interrupted", (Throwable)e);
        }
    }

    public void onExit(SignalType signalType, ServerWebExchange serverWebExchange, String identifier, Map<TimeEvent, Time<Long>> events) {
        log.trace("on exit -> (responseSignalType) {} (identifier) {}", (Object)signalType, (Object)identifier);
        ExEnum exSignalType = this.enumParser.parse((Enum<?>)signalType);
        Mono signalTypeMonoCall = this.informationExchangeRepoAsync.updateAttribute(identifier, ExchangeInformationType.signalType.name(), exSignalType);
        Thread helperThread1 = MonoCallSynchronousExecutor.waitForIt(signalTypeMonoCall, "web exchange update " + ExchangeInformationType.signalType.name(), 50L);
        Mono eventsMonoCall = this.informationExchangeRepoAsync.updateAttribute(identifier, ExchangeInformationType.events.name(), events);
        Thread helperThread2 = MonoCallSynchronousExecutor.waitForIt(eventsMonoCall, "web exchange update " + ExchangeInformationType.events.name(), 50L);
        this.parserHelper.identifyAndPersist(serverWebExchange, ExchangeInformationType.serverHttpResponse);
        this.parserHelper.identifyAndPersist(serverWebExchange, ExchangeInformationType.applicationContext);
    }
}

