/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.repository.asynchronous;

import open.source.exchange.entity.InformationExchange;
import open.source.exchange.repository.asynchronous.InformationExchangeRepoAsyncCustom;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class InformationExchangeRepoAsyncImpl
implements InformationExchangeRepoAsyncCustom {
    private static final Logger log = LogManager.getLogger(InformationExchangeRepoAsyncImpl.class);
    private final ReactiveMongoTemplate reactiveMongoTemplate;

    @Override
    public <T> Mono<Boolean> updateAttribute(String identifier, String attributeName, T attributeValue) {
        log.debug("update attribute -> (identifier) {} (attributeName) {} (attributeValue) {}", (Object)identifier, (Object)attributeName, attributeValue);
        if (null != attributeValue) {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)identifier));
            Update update = new Update().set(attributeName, attributeValue);
            return this.reactiveMongoTemplate.updateFirst(query, update, InformationExchange.class).flatMap(updateResult -> {
                long matchedCount = updateResult.getMatchedCount();
                boolean wasAcknowledged = updateResult.wasAcknowledged();
                boolean isModifiedCountAvailable = updateResult.isModifiedCountAvailable();
                long modifiedCount = updateResult.getModifiedCount();
                log.debug("update result -> (identifier) {} (attributeName) {} (matchedCount) {} (wasAcknowledged) {} (isModifiedCountAvailable) {} (modifiedCount) {}", (Object)identifier, (Object)attributeName, (Object)matchedCount, (Object)wasAcknowledged, (Object)isModifiedCountAvailable, (Object)modifiedCount);
                return Mono.just((Object)true);
            });
        }
        return Mono.just((Object)false);
    }

    public InformationExchangeRepoAsyncImpl(ReactiveMongoTemplate reactiveMongoTemplate) {
        this.reactiveMongoTemplate = reactiveMongoTemplate;
    }
}

