/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.Chronology;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExChronology;
import open.source.exchange.model.ExInstant;
import open.source.exchange.model.ExZonedDateTime;
import open.source.exchange.parser.ChronologyParser;
import open.source.exchange.parser.InstantParser;
import open.source.exchange.parser.ObjectParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZonedDateTimeParser {
    private static final Logger log = LogManager.getLogger(ZonedDateTimeParser.class);
    @Autowired
    private ObjectParser objectParser;
    @Autowired
    private ChronologyParser chronologyParser;
    @Autowired
    private InstantParser instantParser;

    private ExZonedDateTime parseCore(ZonedDateTime zonedDateTime) {
        log.trace("parse core -> (zonedDateTime) {}", (Object)zonedDateTime);
        ExZonedDateTime exZonedDateTime = null;
        if (null != zonedDateTime) {
            ExBase exBase = this.objectParser.parse(zonedDateTime);
            exZonedDateTime = new ExZonedDateTime(exBase);
            Chronology chronology = zonedDateTime.getChronology();
            ExChronology exChronology = this.chronologyParser.parse(chronology);
            exZonedDateTime.setChronology(exChronology);
            int dayOfMonth = zonedDateTime.getDayOfMonth();
            exZonedDateTime.setDayOfMonth(dayOfMonth);
            DayOfWeek dayOfWeek = zonedDateTime.getDayOfWeek();
            exZonedDateTime.setDayOfWeek(dayOfWeek);
            int dayOfYear = zonedDateTime.getDayOfYear();
            exZonedDateTime.setDayOfYear(dayOfYear);
            int hour = zonedDateTime.getHour();
            exZonedDateTime.setHour(hour);
            int minute = zonedDateTime.getMinute();
            exZonedDateTime.setMinute(minute);
            Month month = zonedDateTime.getMonth();
            exZonedDateTime.setMonth(month);
            int monthValue = zonedDateTime.getMonthValue();
            exZonedDateTime.setMonthValue(monthValue);
            int nano = zonedDateTime.getNano();
            exZonedDateTime.setNano(nano);
            ZoneOffset offset = zonedDateTime.getOffset();
            exZonedDateTime.setOffset(offset);
            int second = zonedDateTime.getSecond();
            exZonedDateTime.setSecond(second);
            int year = zonedDateTime.getYear();
            exZonedDateTime.setYear(year);
            ZoneId zone = zonedDateTime.getZone();
            exZonedDateTime.setZone(zone);
            long toEpochSecond = zonedDateTime.toEpochSecond();
            exZonedDateTime.setToEpochSecond(toEpochSecond);
            Instant toInstant = zonedDateTime.toInstant();
            ExInstant exInstant = this.instantParser.parse(toInstant);
            exZonedDateTime.setToInstant(exInstant);
            LocalDate toLocalDate = zonedDateTime.toLocalDate();
            exZonedDateTime.setToLocalDate(toLocalDate);
            LocalDateTime toLocalDateTime = zonedDateTime.toLocalDateTime();
            exZonedDateTime.setToLocalDateTime(toLocalDateTime);
            LocalTime toLocalTime = zonedDateTime.toLocalTime();
            exZonedDateTime.setToLocalTime(toLocalTime);
            OffsetDateTime toOffsetDateTime = zonedDateTime.toOffsetDateTime();
            exZonedDateTime.setToOffsetDateTime(toOffsetDateTime);
        }
        return exZonedDateTime;
    }

    private ExZonedDateTime parseNonCore(ZonedDateTime zonedDateTime, ExZonedDateTime exZonedDateTime) {
        log.trace("parse non core -> (zonedDateTime) {}", (Object)zonedDateTime);
        if (null != exZonedDateTime) {
            ZonedDateTime withEarlierOffsetAtOverlap = zonedDateTime.withEarlierOffsetAtOverlap();
            ExZonedDateTime exWithEarlierOffsetAtOverlap = this.parseCore(withEarlierOffsetAtOverlap);
            exZonedDateTime.setWithEarlierOffsetAtOverlap(exWithEarlierOffsetAtOverlap);
            ZonedDateTime withFixedOffsetZone = zonedDateTime.withFixedOffsetZone();
            ExZonedDateTime exWithFixedOffsetZone = this.parseCore(withFixedOffsetZone);
            exZonedDateTime.setWithFixedOffsetZone(exWithFixedOffsetZone);
            ZonedDateTime withLaterOffsetAtOverlap = zonedDateTime.withLaterOffsetAtOverlap();
            ExZonedDateTime exWithLaterOffsetAtOverlap = this.parseCore(withLaterOffsetAtOverlap);
            exZonedDateTime.setWithLaterOffsetAtOverlap(exWithLaterOffsetAtOverlap);
        }
        return exZonedDateTime;
    }

    public ExZonedDateTime parse(ZonedDateTime zonedDateTime) {
        log.trace("parse -> (zonedDateTime) {}", (Object)zonedDateTime);
        ExZonedDateTime exZonedDateTime = this.parseCore(zonedDateTime);
        return this.parseNonCore(zonedDateTime, exZonedDateTime);
    }
}

