/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.net.URL;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExURL;
import open.source.exchange.parser.ObjectParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class URLParser {
    private static final Logger log = LogManager.getLogger(URLParser.class);
    @Autowired
    private ObjectParser objectParser;

    public ExURL parse(URL url) {
        log.trace("parse -> (url) {}", (Object)url);
        ExURL exURL = null;
        if (null != url) {
            ExBase exBase = this.objectParser.parse(url);
            exURL = new ExURL(exBase);
            String authority = url.getAuthority();
            exURL.setAuthority(authority);
            int defaultPort = url.getDefaultPort();
            exURL.setDefaultPort(defaultPort);
            String file = url.getFile();
            exURL.setFile(file);
            String host = url.getHost();
            exURL.setHost(host);
            String path = url.getPath();
            exURL.setPath(path);
            int port = url.getPort();
            exURL.setPort(port);
            String protocol = url.getProtocol();
            exURL.setProtocol(protocol);
            String query = url.getQuery();
            exURL.setQuery(query);
            String ref = url.getRef();
            exURL.setRef(ref);
            String userInfo = url.getUserInfo();
            exURL.setUserInfo(userInfo);
            String toExternalForm = url.toExternalForm();
            exURL.setToExternalForm(toExternalForm);
        }
        return exURL;
    }
}

