/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExURI;
import open.source.exchange.model.ExURL;
import open.source.exchange.parser.ObjectParser;
import open.source.exchange.parser.URLParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class URIParser {
    private static final Logger log = LogManager.getLogger(URIParser.class);
    @Autowired
    private ObjectParser objectParser;
    @Autowired
    private URLParser urlParser;

    private ExURI parseCore(URI uri) {
        ExBase exBase = this.objectParser.parse(uri);
        ExURI exURI = new ExURI(exBase);
        String authority = uri.getAuthority();
        exURI.setAuthority(authority);
        String fragment = uri.getFragment();
        exURI.setFragment(fragment);
        String host = uri.getHost();
        exURI.setHost(host);
        String path = uri.getPath();
        exURI.setPath(path);
        int port = uri.getPort();
        exURI.setPort(port);
        String query = uri.getQuery();
        exURI.setQuery(query);
        String rawAuthority = uri.getRawAuthority();
        exURI.setRawAuthority(rawAuthority);
        String rawFragment = uri.getRawFragment();
        exURI.setRawFragment(rawFragment);
        String rawPath = uri.getRawPath();
        exURI.setRawPath(rawPath);
        String rawQuery = uri.getRawQuery();
        exURI.setRawQuery(rawQuery);
        String rawSchemeSpecificPart = uri.getRawSchemeSpecificPart();
        exURI.setRawSchemeSpecificPart(rawSchemeSpecificPart);
        String rawUserInfo = uri.getRawUserInfo();
        exURI.setRawUserInfo(rawUserInfo);
        String scheme = uri.getScheme();
        exURI.setScheme(scheme);
        String schemeSpecificPart = uri.getSchemeSpecificPart();
        exURI.setSchemeSpecificPart(schemeSpecificPart);
        String userInfo = uri.getUserInfo();
        exURI.setUserInfo(userInfo);
        boolean absoluteFlag = uri.isAbsolute();
        exURI.setAbsoluteFlag(absoluteFlag);
        boolean opaqueFlag = uri.isOpaque();
        exURI.setOpaqueFlag(opaqueFlag);
        String toASCIIString = uri.toASCIIString();
        exURI.setToASCIIString(toASCIIString);
        try {
            URL url = uri.toURL();
            ExURL exURL = this.urlParser.parse(url);
            exURI.setUrl(exURL);
        }
        catch (MalformedURLException e) {
            log.error("error identifying url", (Throwable)e);
        }
        return exURI;
    }

    public ExURI parse(URI uri) {
        log.trace("parse -> (uri) {}", (Object)uri);
        ExURI exURI = null;
        if (null != uri) {
            exURI = this.parseCore(uri);
            URI normalize = uri.normalize();
            ExURI exNormalize = this.parseCore(normalize);
            exURI.setNormalize(exNormalize);
            try {
                URI serverAuthority = uri.parseServerAuthority();
                ExURI exServerAuthority = this.parseCore(serverAuthority);
                exURI.setServerAuthority(exServerAuthority);
            }
            catch (URISyntaxException e) {
                log.error("error parsing uri server authority", (Throwable)e);
            }
        }
        return exURI;
    }
}

