/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.security.cert.X509Certificate;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExSslInfo;
import open.source.exchange.model.ExX509Certificate;
import open.source.exchange.parser.ObjectParser;
import open.source.exchange.parser.X509CertificateParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.stereotype.Service;

@Service
public class SslInfoParser {
    private static final Logger log = LogManager.getLogger(SslInfoParser.class);
    @Autowired
    private ObjectParser objectParser;
    @Autowired
    private X509CertificateParser x509CertificateParser;

    public ExSslInfo parse(SslInfo sslInfo) {
        log.trace("parse -> (sslInfo) {}", (Object)sslInfo);
        ExSslInfo exSslInfo = null;
        if (null != sslInfo) {
            ExBase exBase = this.objectParser.parse(sslInfo);
            exSslInfo = new ExSslInfo(exBase);
            String sessionId = sslInfo.getSessionId();
            exSslInfo.setSessionId(sessionId);
            X509Certificate[] peerCertificates = sslInfo.getPeerCertificates();
            ExX509Certificate[] exX509CertificateArray = null;
            if (null != peerCertificates && peerCertificates.length > 0) {
                exX509CertificateArray = new ExX509Certificate[peerCertificates.length];
                for (int index = 0; index < peerCertificates.length; ++index) {
                    ExX509Certificate exX509Certificate;
                    X509Certificate peerCertificate = peerCertificates[index];
                    exX509CertificateArray[index] = exX509Certificate = this.x509CertificateParser.parse(peerCertificate);
                }
            }
            exSslInfo.setPeerCertificates(exX509CertificateArray);
        }
        return exSslInfo;
    }
}

