/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import open.source.exchange.entity.ExApplicationContext;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExLocaleContext;
import open.source.exchange.model.ExMultiValueMap;
import open.source.exchange.model.ExPart;
import open.source.exchange.model.ExPrincipal;
import open.source.exchange.model.ExServerHttpRequest;
import open.source.exchange.model.ExServerHttpResponse;
import open.source.exchange.model.ExWebSession;
import open.source.exchange.model.Information;
import open.source.exchange.parser.ApplicationContextParser;
import open.source.exchange.parser.LocaleContextParser;
import open.source.exchange.parser.MultiValueMapParser;
import open.source.exchange.parser.ObjectParser;
import open.source.exchange.parser.PartParser;
import open.source.exchange.parser.PrincipalParser;
import open.source.exchange.parser.ServerHttpRequestParser;
import open.source.exchange.parser.ServerHttpResponseParser;
import open.source.exchange.parser.WebSessionParser;
import open.source.exchange.utility.asynchronous.MonoCallSynchronousExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

@Service
@Deprecated
public class ServerWebExchangeParser {
    private static final Logger log = LogManager.getLogger(ServerWebExchangeParser.class);
    @Autowired
    private ObjectParser objectParser;
    @Autowired
    private ApplicationContextParser applicationContextParser;
    @Autowired
    private LocaleContextParser localeContextParser;
    @Autowired
    private ServerHttpRequestParser serverHttpRequestParser;
    @Autowired
    private ServerHttpResponseParser serverHttpResponseParser;
    @Autowired
    private PrincipalParser principalParser;
    @Autowired
    private WebSessionParser webSessionParser;
    @Autowired
    private MultiValueMapParser multiValueMapParser;
    @Autowired
    private PartParser partParser;

    private Mono<Information> parseAsyncState(ServerWebExchange serverWebExchange, Information information) {
        log.trace("parse async state -> (serverWebExchange) {} (information) {}", (Object)serverWebExchange, (Object)information);
        return serverWebExchange.getPrincipal().flux().collectList().flatMap(principalList -> {
            log.trace("got -> (principalList) {}", principalList);
            Principal principal = principalList.isEmpty() ? null : (Principal)principalList.get(0);
            ExPrincipal exPrincipal = this.principalParser.parse(principal);
            information.setPrincipal(exPrincipal);
            return serverWebExchange.getSession().flux().collectList().flatMap(sessionList -> {
                log.trace("got -> (sessionList) {}", sessionList);
                WebSession session = sessionList.isEmpty() ? null : (WebSession)sessionList.get(0);
                ExWebSession exSession = this.webSessionParser.parse(session);
                information.setSession(exSession);
                return serverWebExchange.getFormData().flux().collectList().flatMap(formDataList -> {
                    log.trace("got -> (formDataList) {}", formDataList);
                    MultiValueMap formData = formDataList.isEmpty() ? null : (MultiValueMap)formDataList.get(0);
                    ExMultiValueMap<String, String> exFormData = this.multiValueMapParser.parse(formData);
                    information.setFormData(exFormData);
                    return serverWebExchange.getMultipartData().flux().collectList().flatMap(multipartDataList -> {
                        log.trace("got -> (multipartDataList) {}", multipartDataList);
                        MultiValueMap multipartData = multipartDataList.isEmpty() ? null : (MultiValueMap)multipartDataList.get(0);
                        ExMultiValueMap exMultiValueMap = this.multiValueMapParser.parse(multipartData);
                        if (null != exMultiValueMap) {
                            ExMultiValueMap<String, ExPart> exParts = new ExMultiValueMap<String, ExPart>();
                            exParts.setClazz(exMultiValueMap.getClazz());
                            exParts.setHashCode(exMultiValueMap.getHashCode());
                            exParts.setToString(exMultiValueMap.getToString());
                            exParts.setSize(exMultiValueMap.getSize());
                            exParts.setEmpty(exMultiValueMap.isEmpty());
                            Map mapVsList = exMultiValueMap.getMapVsList();
                            TreeMap mapVsExList = null;
                            if (null != mapVsList) {
                                mapVsExList = new TreeMap();
                                for (String key : mapVsList.keySet()) {
                                    List values = mapVsList.get(key);
                                    int size = null != values ? values.size() : 1;
                                    ArrayList exValueList = new ArrayList(size);
                                    if (null != values) {
                                        int index = 0;
                                        for (Part part : values) {
                                            Mono exPartMono = this.partParser.parse(part).map(exPart -> {
                                                exValueList.add(exPart);
                                                return exPart;
                                            });
                                            Thread helperThread = MonoCallSynchronousExecutor.waitForIt(exPartMono, "get part data for key: " + key + " index: " + index, 10L);
                                            try {
                                                helperThread.join();
                                            }
                                            catch (InterruptedException e) {
                                                log.error("interrupted", (Throwable)e);
                                            }
                                            ++index;
                                        }
                                    }
                                    mapVsExList.put(key, exValueList);
                                }
                            }
                            exParts.setMapVsList(mapVsExList);
                            information.setMultipartData(exParts);
                        }
                        ServerHttpRequest request = serverWebExchange.getRequest();
                        return this.serverHttpRequestParser.parse(request).flatMap(exServerHttpRequest -> {
                            information.setServerHttpRequest((ExServerHttpRequest)exServerHttpRequest);
                            return Mono.just((Object)information);
                        });
                    });
                });
            });
        });
    }

    private void parseSyncState(ServerWebExchange serverWebExchange, Information information) {
        log.trace("parse sync state -> (serverWebExchange) {} (information) {}", (Object)serverWebExchange, (Object)information);
        ApplicationContext applicationContext = serverWebExchange.getApplicationContext();
        ExApplicationContext exApplicationContext = this.applicationContextParser.parse(applicationContext);
        Map attributes = serverWebExchange.getAttributes();
        information.setAttributes(attributes);
        LocaleContext localeContext = serverWebExchange.getLocaleContext();
        ExLocaleContext exLocaleContext = this.localeContextParser.parse(localeContext);
        information.setLocaleContext(exLocaleContext);
        String logPrefix = serverWebExchange.getLogPrefix();
        information.setLogPrefix(logPrefix);
        ServerHttpResponse response = serverWebExchange.getResponse();
        ExServerHttpResponse exServerHttpResponse = this.serverHttpResponseParser.parse(response);
        information.setServerHttpResponse(exServerHttpResponse);
        boolean notModifiedFlag = serverWebExchange.isNotModified();
        information.setNotModifiedFlag(notModifiedFlag);
    }

    @Deprecated
    public Mono<Information> parse(ServerWebExchange serverWebExchange) {
        log.trace("parse -> (serverWebExchange) {}", (Object)serverWebExchange);
        Information information = new Information();
        if (null == serverWebExchange) {
            return Mono.just((Object)information);
        }
        ExBase exBase = this.objectParser.parse(serverWebExchange);
        information = new Information(exBase);
        this.parseSyncState(serverWebExchange, information);
        return this.parseAsyncState(serverWebExchange, information);
    }
}

