/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExHttpHeaders;
import open.source.exchange.model.ExHttpStatus;
import open.source.exchange.model.ExMultiValueMap;
import open.source.exchange.model.ExResponseCookie;
import open.source.exchange.model.ExServerHttpResponse;
import open.source.exchange.parser.HttpHeadersParser;
import open.source.exchange.parser.HttpStatusParser;
import open.source.exchange.parser.MultiValueMapParser;
import open.source.exchange.parser.ObjectParser;
import open.source.exchange.parser.ResponseCookieParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class ServerHttpResponseParser {
    private static final Logger log = LogManager.getLogger(ServerHttpResponseParser.class);
    @Autowired
    private ObjectParser objectParser;
    @Autowired
    private MultiValueMapParser multiValueMapParser;
    @Autowired
    private ResponseCookieParser responseCookieParser;
    @Autowired
    private HttpHeadersParser httpHeadersParser;
    @Autowired
    private HttpStatusParser httpStatusParser;

    public ExServerHttpResponse parse(ServerHttpResponse serverHttpResponse) {
        log.trace("parse -> (serverHttpResponse) {}", (Object)serverHttpResponse);
        ExServerHttpResponse exServerHttpResponse = null;
        if (null != serverHttpResponse) {
            ExBase exBase = this.objectParser.parse(serverHttpResponse);
            exServerHttpResponse = new ExServerHttpResponse(exBase);
            DataBufferFactory bufferFactory = serverHttpResponse.bufferFactory();
            MultiValueMap cookies = serverHttpResponse.getCookies();
            ExMultiValueMap exMultiValueMap = this.multiValueMapParser.parse(cookies);
            ExMultiValueMap exCookies = null;
            if (null != exMultiValueMap) {
                exCookies = new ExMultiValueMap();
                exCookies.setClazz(exMultiValueMap.getClazz());
                exCookies.setHashCode(exMultiValueMap.getHashCode());
                exCookies.setToString(exMultiValueMap.getToString());
                exCookies.setSize(exMultiValueMap.getSize());
                exCookies.setEmpty(exMultiValueMap.isEmpty());
                Map mapVsList = exMultiValueMap.getMapVsList();
                TreeMap mapVsExList = null;
                if (null != mapVsList) {
                    mapVsExList = new TreeMap();
                    for (String key : mapVsList.keySet()) {
                        List values = mapVsList.get(key);
                        ArrayList<ExResponseCookie> exValueList = null;
                        if (null != values) {
                            exValueList = new ArrayList<ExResponseCookie>();
                            for (ResponseCookie responseCookie : values) {
                                ExResponseCookie exResponseCookie = this.responseCookieParser.parse(responseCookie);
                                exValueList.add(exResponseCookie);
                            }
                        }
                        mapVsExList.put(key, exValueList);
                    }
                }
                exCookies.setMapVsList(mapVsExList);
            }
            exServerHttpResponse.setCookies(exCookies);
            HttpHeaders headers = serverHttpResponse.getHeaders();
            ExHttpHeaders exHttpHeaders = this.httpHeadersParser.parse(headers);
            exServerHttpResponse.setHeaders(exHttpHeaders);
            HttpStatus statusCode = serverHttpResponse.getStatusCode();
            ExHttpStatus exHttpStatus = this.httpStatusParser.parse(statusCode);
            exServerHttpResponse.setStatusCode(exHttpStatus);
            boolean committedFlag = serverHttpResponse.isCommitted();
            exServerHttpResponse.setCommittedFlag(committedFlag);
        }
        return exServerHttpResponse;
    }
}

