/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExHttpCookie;
import open.source.exchange.model.ExHttpHeaders;
import open.source.exchange.model.ExHttpMethod;
import open.source.exchange.model.ExInetSocketAddress;
import open.source.exchange.model.ExMultiValueMap;
import open.source.exchange.model.ExRequestPath;
import open.source.exchange.model.ExServerHttpRequest;
import open.source.exchange.model.ExSslInfo;
import open.source.exchange.model.ExURI;
import open.source.exchange.parser.DataBufferListParser;
import open.source.exchange.parser.HttpCookieParser;
import open.source.exchange.parser.HttpHeadersParser;
import open.source.exchange.parser.HttpMethodParser;
import open.source.exchange.parser.InetSocketAddressParser;
import open.source.exchange.parser.MultiValueMapParser;
import open.source.exchange.parser.ObjectParser;
import open.source.exchange.parser.RequestPathParser;
import open.source.exchange.parser.SslInfoParser;
import open.source.exchange.parser.URIParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.RequestPath;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Mono;

@Service
public class ServerHttpRequestParser {
    private static final Logger log = LogManager.getLogger(ServerHttpRequestParser.class);
    @Autowired
    private ObjectParser objectParser;
    @Autowired
    private MultiValueMapParser multiValueMapParser;
    @Autowired
    private HttpCookieParser httpCookieParser;
    @Autowired
    private HttpHeadersParser httpHeadersParser;
    @Autowired
    private HttpMethodParser httpMethodParser;
    @Autowired
    private RequestPathParser requestPathParser;
    @Autowired
    private InetSocketAddressParser inetSocketAddressParser;
    @Autowired
    private SslInfoParser sslInfoParser;
    @Autowired
    private URIParser uriParser;
    @Autowired
    private DataBufferListParser dataBufferListParser;

    private Mono<ExServerHttpRequest> parseAsyncState(ServerHttpRequest serverHttpRequest, ExServerHttpRequest exServerHttpRequest) {
        log.trace("parse async state -> (serverHttpRequest) {} (exServerHttpRequest) {}", (Object)serverHttpRequest, (Object)exServerHttpRequest);
        return Mono.just((Object)exServerHttpRequest);
    }

    private void parseSyncState(ServerHttpRequest serverHttpRequest, ExServerHttpRequest exServerHttpRequest) {
        log.trace("parse sync state -> (serverHttpRequest) {} (exServerHttpRequest) {}", (Object)serverHttpRequest, (Object)exServerHttpRequest);
        MultiValueMap cookies = serverHttpRequest.getCookies();
        ExMultiValueMap exMultiValueMap = this.multiValueMapParser.parse(cookies);
        ExMultiValueMap exCookies = null;
        if (null != exMultiValueMap) {
            exCookies = new ExMultiValueMap();
            exCookies.setClazz(exMultiValueMap.getClazz());
            exCookies.setHashCode(exMultiValueMap.getHashCode());
            exCookies.setToString(exMultiValueMap.getToString());
            exCookies.setSize(exMultiValueMap.getSize());
            exCookies.setEmpty(exMultiValueMap.isEmpty());
            Map mapVsList = exMultiValueMap.getMapVsList();
            TreeMap mapVsExList = null;
            if (null != mapVsList) {
                mapVsExList = new TreeMap();
                for (String key : mapVsList.keySet()) {
                    List values = mapVsList.get(key);
                    ArrayList<ExHttpCookie> exValueList = null;
                    if (null != values) {
                        exValueList = new ArrayList<ExHttpCookie>();
                        for (HttpCookie httpCookie : values) {
                            ExHttpCookie exHttpCookie = this.httpCookieParser.parse(httpCookie);
                            exValueList.add(exHttpCookie);
                        }
                    }
                    mapVsExList.put(key, exValueList);
                }
            }
            exCookies.setMapVsList(mapVsExList);
        }
        exServerHttpRequest.setCookies(exCookies);
        HttpHeaders headers = serverHttpRequest.getHeaders();
        ExHttpHeaders exHttpHeaders = this.httpHeadersParser.parse(headers);
        exServerHttpRequest.setHeaders(exHttpHeaders);
        String id = serverHttpRequest.getId();
        exServerHttpRequest.setId(id);
        HttpMethod method = serverHttpRequest.getMethod();
        ExHttpMethod exHttpMethod = this.httpMethodParser.parse(method);
        exServerHttpRequest.setMethod(exHttpMethod);
        String methodValue = serverHttpRequest.getMethodValue();
        exServerHttpRequest.setMethodValue(methodValue);
        RequestPath path = serverHttpRequest.getPath();
        ExRequestPath exRequestPath = this.requestPathParser.parse(path);
        exServerHttpRequest.setPath(exRequestPath);
        MultiValueMap queryParams = serverHttpRequest.getQueryParams();
        ExMultiValueMap<String, String> exQueryParams = this.multiValueMapParser.parse(queryParams);
        exServerHttpRequest.setQueryParams(exQueryParams);
        InetSocketAddress remoteAddress = serverHttpRequest.getRemoteAddress();
        ExInetSocketAddress exInetSocketAddress = this.inetSocketAddressParser.parse(remoteAddress);
        exServerHttpRequest.setRemoteAddress(exInetSocketAddress);
        SslInfo sslInfo = serverHttpRequest.getSslInfo();
        ExSslInfo exSslInfo = this.sslInfoParser.parse(sslInfo);
        exServerHttpRequest.setSslInfo(exSslInfo);
        URI uri = serverHttpRequest.getURI();
        ExURI exURI = this.uriParser.parse(uri);
        exServerHttpRequest.setUri(exURI);
    }

    public Mono<ExServerHttpRequest> parse(ServerHttpRequest serverHttpRequest) {
        log.trace("parse -> (serverHttpRequest) {}", (Object)serverHttpRequest);
        ExServerHttpRequest exServerHttpRequest = new ExServerHttpRequest();
        if (null == serverHttpRequest) {
            return Mono.just((Object)exServerHttpRequest);
        }
        ExBase exBase = this.objectParser.parse(serverHttpRequest);
        exServerHttpRequest = new ExServerHttpRequest(exBase);
        this.parseSyncState(serverHttpRequest, exServerHttpRequest);
        return this.parseAsyncState(serverHttpRequest, exServerHttpRequest);
    }
}

