/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.time.Duration;
import open.source.exchange.model.ExDuration;
import open.source.exchange.model.ExHttpCookie;
import open.source.exchange.model.ExResponseCookie;
import open.source.exchange.parser.DurationParser;
import open.source.exchange.parser.HttpCookieParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpCookie;
import org.springframework.http.ResponseCookie;
import org.springframework.stereotype.Service;

@Service
public class ResponseCookieParser {
    private static final Logger log = LogManager.getLogger(ResponseCookieParser.class);
    @Autowired
    private HttpCookieParser httpCookieParser;
    @Autowired
    private DurationParser durationParser;

    public ExResponseCookie parse(ResponseCookie responseCookie) {
        log.trace("parse -> (responseCookie) {}", (Object)responseCookie);
        ExResponseCookie exResponseCookie = null;
        if (null != responseCookie) {
            ExHttpCookie exHttpCookie = this.httpCookieParser.parse((HttpCookie)responseCookie);
            exResponseCookie = new ExResponseCookie(exHttpCookie);
            String domain = responseCookie.getDomain();
            exResponseCookie.setDomain(domain);
            Duration maxAge = responseCookie.getMaxAge();
            ExDuration exMaxAge = this.durationParser.parse(maxAge);
            exResponseCookie.setMaxAge(exMaxAge);
            String path = responseCookie.getPath();
            exResponseCookie.setPath(path);
            String sameSite = responseCookie.getSameSite();
            exResponseCookie.setSameSite(sameSite);
            boolean httpOnlyFlag = responseCookie.isHttpOnly();
            exResponseCookie.setHttpOnlyFlag(httpOnlyFlag);
            boolean secureFlag = responseCookie.isSecure();
            exResponseCookie.setSecureFlag(secureFlag);
        }
        return exResponseCookie;
    }
}

