/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.security.PublicKey;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExPublicKey;
import open.source.exchange.parser.ObjectParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PublicKeyParser {
    private static final Logger log = LogManager.getLogger(PublicKeyParser.class);
    @Autowired
    private ObjectParser objectParser;

    public ExPublicKey parse(PublicKey publicKey) {
        log.trace("parse -> (publicKey) {}", (Object)publicKey);
        ExPublicKey exPublicKey = null;
        if (null != publicKey) {
            ExBase exBase = this.objectParser.parse(publicKey);
            exPublicKey = new ExPublicKey(exBase);
            String algorithm = publicKey.getAlgorithm();
            exPublicKey.setAlgorithm(algorithm);
            byte[] encoded = publicKey.getEncoded();
            exPublicKey.setEncoded(encoded);
            String format = publicKey.getFormat();
            exPublicKey.setFormat(format);
        }
        return exPublicKey;
    }
}

