/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.util.ArrayList;
import java.util.List;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExElement;
import open.source.exchange.model.ExPathContainer;
import open.source.exchange.parser.ElementParser;
import open.source.exchange.parser.ObjectParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.PathContainer;
import org.springframework.stereotype.Service;

@Service
public class PathContainerParser {
    private static final Logger log = LogManager.getLogger(PathContainerParser.class);
    @Autowired
    private ObjectParser objectParser;
    @Autowired
    private ElementParser elementParser;

    public ExPathContainer parse(PathContainer pathContainer) {
        log.trace("parse -> (pathContainer) {}", (Object)pathContainer);
        ExPathContainer exPathContainer = null;
        if (null != pathContainer) {
            ExBase exBase = this.objectParser.parse(pathContainer);
            exPathContainer = new ExPathContainer(exBase);
            List elements = pathContainer.elements();
            ArrayList<ExElement> exElementList = new ArrayList<ExElement>();
            if (null != elements) {
                for (PathContainer.Element element : elements) {
                    ExElement exElement = this.elementParser.parse(element);
                    exElementList.add(exElement);
                }
            }
            exPathContainer.setElements(exElementList);
            String value = pathContainer.value();
            exPathContainer.setValue(value);
        }
        return exPathContainer;
    }
}

