/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExHttpHeaders;
import open.source.exchange.model.ExPart;
import open.source.exchange.parser.DataBufferListParser;
import open.source.exchange.parser.HttpHeadersParser;
import open.source.exchange.parser.ObjectParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.codec.multipart.Part;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class PartParser {
    private static final Logger log = LogManager.getLogger(PartParser.class);
    @Autowired
    private ObjectParser objectParser;
    @Autowired
    private HttpHeadersParser httpHeadersParser;
    @Autowired
    private DataBufferListParser dataBufferListParser;

    private Mono<ExPart> parseAsyncState(Part part, ExPart exPart) {
        log.trace("parse sync state -> (part) {} (exPart) {}", (Object)part, (Object)exPart);
        Flux content = part.content();
        return Mono.just((Object)exPart);
    }

    private ExPart parseSyncState(Part part) {
        log.trace("parse sync state -> (part) {}", (Object)part);
        ExBase exBase = this.objectParser.parse(part);
        ExPart exPart = new ExPart(exBase);
        String name = part.name();
        exPart.setName(name);
        HttpHeaders headers = part.headers();
        ExHttpHeaders exHttpHeaders = this.httpHeadersParser.parse(headers);
        exPart.setHeaders(exHttpHeaders);
        return exPart;
    }

    public Mono<ExPart> parse(Part part) {
        log.trace("parse -> (part) {}", (Object)part);
        ExPart exPart = new ExPart();
        if (null == part) {
            return Mono.just((Object)exPart);
        }
        exPart = this.parseSyncState(part);
        return this.parseAsyncState(part, exPart);
    }
}

