/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExMultiValueMap;
import open.source.exchange.parser.ObjectParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class MultiValueMapParser {
    private static final Logger log = LogManager.getLogger(MultiValueMapParser.class);
    @Autowired
    private ObjectParser objectParser;

    public <K, V> ExMultiValueMap<K, V> parse(MultiValueMap<K, V> multiValueMap) {
        log.trace("parse -> (multiValueMap) {}", multiValueMap);
        ExMultiValueMap exMultiValueMap = null;
        if (null != multiValueMap) {
            ExBase exBase = this.objectParser.parse(multiValueMap);
            exMultiValueMap = new ExMultiValueMap(exBase);
            int size = multiValueMap.size();
            exMultiValueMap.setSize(size);
            boolean isEmpty = multiValueMap.isEmpty();
            exMultiValueMap.setEmpty(isEmpty);
            if (size > 0) {
                TreeMap mapVsList = new TreeMap();
                for (Object key : multiValueMap.keySet()) {
                    List list = (List)multiValueMap.get(key);
                    ArrayList values = new ArrayList();
                    values.addAll(list);
                    mapVsList.put(key, values);
                }
                exMultiValueMap.setMapVsList(mapVsList);
            }
        }
        return exMultiValueMap;
    }
}

