/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.nio.charset.Charset;
import java.util.Map;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExCharset;
import open.source.exchange.model.ExMediaType;
import open.source.exchange.parser.CharsetParser;
import open.source.exchange.parser.ObjectParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

@Service
public class MediaTypeParser {
    private static final Logger log = LogManager.getLogger(MediaTypeParser.class);
    @Autowired
    private ObjectParser objectParser;
    @Autowired
    private CharsetParser charsetParser;

    private ExMediaType parseCore(MediaType mediaType) {
        log.trace("parse core -> (mediaType) {}", (Object)mediaType);
        ExMediaType exMediaType = null;
        if (null != mediaType) {
            ExBase exBase = this.objectParser.parse(mediaType);
            exMediaType = new ExMediaType(exBase);
            Charset charset = mediaType.getCharset();
            ExCharset exCharset = this.charsetParser.parse(charset);
            exMediaType.setCharset(exCharset);
            Map parameters = mediaType.getParameters();
            exMediaType.setParameters(parameters);
            double qualityValue = mediaType.getQualityValue();
            exMediaType.setQualityValue(qualityValue);
            String type = mediaType.getType();
            exMediaType.setType(type);
            String subtype = mediaType.getSubtype();
            exMediaType.setSubtype(subtype);
            boolean isConcrete = mediaType.isConcrete();
            exMediaType.setConcrete(isConcrete);
            boolean isWildcardType = mediaType.isWildcardType();
            exMediaType.setWildcardType(isWildcardType);
            boolean isWildcardSubtype = mediaType.isWildcardSubtype();
            exMediaType.setWildcardSubtype(isWildcardSubtype);
        }
        return exMediaType;
    }

    public ExMediaType parse(MediaType mediaType) {
        log.trace("parse -> (mediaType) {}", (Object)mediaType);
        ExMediaType exMediaType = this.parseCore(mediaType);
        if (null != exMediaType) {
            MediaType removeQualityValue = mediaType.removeQualityValue();
            ExMediaType exRemoveQualityValue = this.parseCore(removeQualityValue);
            exMediaType.setRemoveQualityValue(exRemoveQualityValue);
        }
        return exMediaType;
    }
}

