/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.util.Locale;
import java.util.Set;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExLocale;
import open.source.exchange.parser.ObjectParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocaleParser {
    private static final Logger log = LogManager.getLogger(LocaleParser.class);
    @Autowired
    private ObjectParser objectParser;

    private ExLocale parseCore(Locale locale) {
        log.trace("parse core -> (locale) {}", (Object)locale);
        ExLocale exLocale = null;
        if (null != locale) {
            ExBase exBase = this.objectParser.parse(locale);
            exLocale = new ExLocale(exBase);
            String country = locale.getCountry();
            exLocale.setCountry(country);
            String displayCountry = locale.getDisplayCountry();
            exLocale.setDisplayCountry(displayCountry);
            String displayLanguage = locale.getDisplayLanguage();
            exLocale.setDisplayLanguage(displayLanguage);
            String displayName = locale.getDisplayName();
            exLocale.setDisplayName(displayName);
            String displayScript = locale.getDisplayScript();
            exLocale.setDisplayScript(displayScript);
            String displayVariant = locale.getDisplayVariant();
            exLocale.setDisplayVariant(displayVariant);
            Set<Character> extensionKeys = locale.getExtensionKeys();
            exLocale.setExtensionKeys(extensionKeys);
            String iso3Country = locale.getISO3Country();
            exLocale.setIso3Country(iso3Country);
            String iso3Language = locale.getISO3Language();
            exLocale.setIso3Language(iso3Language);
            String language = locale.getLanguage();
            exLocale.setLanguage(language);
            String script = locale.getScript();
            exLocale.setScript(script);
            Set<String> unicodeLocaleAttributes = locale.getUnicodeLocaleAttributes();
            exLocale.setUnicodeLocaleAttributes(unicodeLocaleAttributes);
            Set<String> unicodeLocaleKeys = locale.getUnicodeLocaleKeys();
            exLocale.setUnicodeLocaleKeys(unicodeLocaleKeys);
            String variant = locale.getVariant();
            exLocale.setVariant(variant);
            boolean hasExtensions = locale.hasExtensions();
            exLocale.setHasExtensions(hasExtensions);
            String toLanguageTag = locale.toLanguageTag();
            exLocale.setToLanguageTag(toLanguageTag);
        }
        return exLocale;
    }

    private ExLocale parseNonCore(Locale locale, ExLocale exLocale) {
        log.trace("parse non core -> (locale) {} (exLocale) {}", (Object)locale, (Object)exLocale);
        if (null != exLocale) {
            Locale stripExtensions = locale.stripExtensions();
            ExLocale exStripExtensions = this.parseCore(stripExtensions);
            exLocale.setStripExtensions(exStripExtensions);
        }
        return exLocale;
    }

    public ExLocale parse(Locale locale) {
        log.trace("parse -> (locale) {}", (Object)locale);
        ExLocale exLocale = this.parseCore(locale);
        return this.parseNonCore(locale, exLocale);
    }
}

