/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.time.Instant;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExInstant;
import open.source.exchange.parser.ObjectParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InstantParser {
    private static final Logger log = LogManager.getLogger(InstantParser.class);
    @Autowired
    private ObjectParser objectParser;

    public ExInstant parse(Instant instant) {
        log.trace("parse -> (instant) {}", (Object)instant);
        ExInstant exInstant = null;
        if (null != instant) {
            ExBase exBase = this.objectParser.parse(instant);
            exInstant = new ExInstant(exBase);
            long epochSecond = instant.getEpochSecond();
            exInstant.setEpochSecond(epochSecond);
            int nano = instant.getNano();
            exInstant.setNano(nano);
            long toEpochMilli = instant.toEpochMilli();
            exInstant.setToEpochMilli(toEpochMilli);
        }
        return exInstant;
    }
}

