/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExInetAddress;
import open.source.exchange.model.ExInetSocketAddress;
import open.source.exchange.parser.InetAddressParser;
import open.source.exchange.parser.ObjectParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InetSocketAddressParser {
    private static final Logger log = LogManager.getLogger(InetSocketAddressParser.class);
    @Autowired
    private ObjectParser objectParser;
    @Autowired
    private InetAddressParser inetAddressParser;

    public ExInetSocketAddress parse(InetSocketAddress inetSocketAddress) {
        log.trace("parse -> (inetSocketAddress) {}", (Object)inetSocketAddress);
        ExInetSocketAddress exInetSocketAddress = null;
        if (null != inetSocketAddress) {
            ExBase exBase = this.objectParser.parse(inetSocketAddress);
            exInetSocketAddress = new ExInetSocketAddress(exBase);
            InetAddress address = inetSocketAddress.getAddress();
            ExInetAddress exInetAddress = this.inetAddressParser.parse(address);
            exInetSocketAddress.setAddress(exInetAddress);
            String hostName = inetSocketAddress.getHostName();
            exInetSocketAddress.setHostName(hostName);
            String hostString = inetSocketAddress.getHostString();
            exInetSocketAddress.setHostString(hostString);
            int port = inetSocketAddress.getPort();
            exInetSocketAddress.setPort(port);
            boolean unresolvedFlag = inetSocketAddress.isUnresolved();
            exInetSocketAddress.setUnresolvedFlag(unresolvedFlag);
        }
        return exInetSocketAddress;
    }
}

