/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import open.source.exchange.model.ExEnum;
import open.source.exchange.model.ExHttpStatus;
import open.source.exchange.model.ExSeries;
import open.source.exchange.parser.EnumParser;
import open.source.exchange.parser.SeriesParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class HttpStatusParser {
    private static final Logger log = LogManager.getLogger(HttpStatusParser.class);
    @Autowired
    private EnumParser enumParser;
    @Autowired
    private SeriesParser seriesParser;

    public ExHttpStatus parse(HttpStatus httpStatus) {
        log.trace("parse -> (httpStatus) {}", (Object)httpStatus);
        ExHttpStatus exHttpStatus = null;
        if (null != httpStatus) {
            ExEnum exEnum = this.enumParser.parse((Enum<?>)httpStatus);
            exHttpStatus = new ExHttpStatus(exEnum);
            int value = httpStatus.value();
            exHttpStatus.setValue(value);
            String reasonPhrase = httpStatus.getReasonPhrase();
            exHttpStatus.setReasonPhrase(reasonPhrase);
            boolean is1xxInformational = httpStatus.is1xxInformational();
            exHttpStatus.set1xxInformational(is1xxInformational);
            boolean is2xxSuccessful = httpStatus.is2xxSuccessful();
            exHttpStatus.set2xxSuccessful(is2xxSuccessful);
            boolean is3xxRedirection = httpStatus.is3xxRedirection();
            exHttpStatus.set3xxRedirection(is3xxRedirection);
            boolean is4xxClientError = httpStatus.is4xxClientError();
            exHttpStatus.set4xxClientError(is4xxClientError);
            boolean is5xxServerError = httpStatus.is5xxServerError();
            exHttpStatus.set5xxServerError(is5xxServerError);
            boolean isError = httpStatus.isError();
            exHttpStatus.setError(isError);
            HttpStatus.Series series = httpStatus.series();
            ExSeries exSeries = this.seriesParser.parse(series);
            exHttpStatus.setSeries(exSeries);
        }
        return exHttpStatus;
    }
}

