/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExCharset;
import open.source.exchange.model.ExContentDisposition;
import open.source.exchange.model.ExHttpHeaders;
import open.source.exchange.model.ExHttpMethod;
import open.source.exchange.model.ExInetSocketAddress;
import open.source.exchange.model.ExLocale;
import open.source.exchange.model.ExLocaleLanguageRange;
import open.source.exchange.model.ExMediaType;
import open.source.exchange.model.ExMultiValueMap;
import open.source.exchange.model.ExURI;
import open.source.exchange.parser.CharsetParser;
import open.source.exchange.parser.ContentDispositionParser;
import open.source.exchange.parser.HttpMethodParser;
import open.source.exchange.parser.InetSocketAddressParser;
import open.source.exchange.parser.LocaleLanguageRangeParser;
import open.source.exchange.parser.LocaleParser;
import open.source.exchange.parser.MediaTypeParser;
import open.source.exchange.parser.MultiValueMapParser;
import open.source.exchange.parser.ObjectParser;
import open.source.exchange.parser.URIParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRange;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

@Service
public class HttpHeadersParser {
    private static final Logger log = LogManager.getLogger(HttpHeadersParser.class);
    @Autowired
    private MultiValueMapParser multiValueMapParser;
    @Autowired
    private MediaTypeParser mediaTypeParser;
    @Autowired
    private CharsetParser charsetParser;
    @Autowired
    private LocaleLanguageRangeParser localeLanguageRangeParser;
    @Autowired
    private LocaleParser localeParser;
    @Autowired
    private HttpMethodParser httpMethodParser;
    @Autowired
    private ContentDispositionParser contentDispositionParser;
    @Autowired
    private InetSocketAddressParser inetSocketAddressParser;
    @Autowired
    private URIParser uriParser;
    @Autowired
    private ObjectParser objectParser;

    public ExHttpHeaders parse(HttpHeaders httpHeaders) {
        log.trace("parse -> (httpHeaders) {}", (Object)httpHeaders);
        ExHttpHeaders exHttpHeaders = null;
        if (null != httpHeaders) {
            List acceptLanguageAsLocales;
            List acceptLanguage;
            List acceptCharset;
            ExMultiValueMap<String, String> exMultiValueMap = this.multiValueMapParser.parse(httpHeaders);
            exHttpHeaders = new ExHttpHeaders(exMultiValueMap);
            List accept = httpHeaders.getAccept();
            if (null != accept && !accept.isEmpty()) {
                ArrayList<ExMediaType> exList = new ArrayList<ExMediaType>();
                for (MediaType mediaType : accept) {
                    ExMediaType exMediaType = this.mediaTypeParser.parse(mediaType);
                    exList.add(exMediaType);
                }
                exHttpHeaders.setAccept(exList);
            }
            if (null != (acceptCharset = httpHeaders.getAcceptCharset()) && !acceptCharset.isEmpty()) {
                ArrayList<ExCharset> exList = new ArrayList<ExCharset>();
                for (Object charset : acceptCharset) {
                    ExCharset exCharset = this.charsetParser.parse((Charset)charset);
                    exList.add(exCharset);
                }
                exHttpHeaders.setAcceptCharset(exList);
            }
            if (null != (acceptLanguage = httpHeaders.getAcceptLanguage())) {
                ArrayList<ExLocaleLanguageRange> exList = new ArrayList<ExLocaleLanguageRange>();
                for (Object localeLanguageRange : acceptLanguage) {
                    ExLocaleLanguageRange exLocaleLanguageRange = this.localeLanguageRangeParser.parse((Locale.LanguageRange)localeLanguageRange);
                    exList.add(exLocaleLanguageRange);
                }
                exHttpHeaders.setAcceptLanguage(exList);
            }
            if (null != (acceptLanguageAsLocales = httpHeaders.getAcceptLanguageAsLocales())) {
                ArrayList<ExLocale> exLocaleList = new ArrayList<ExLocale>();
                for (Locale locale : acceptLanguageAsLocales) {
                    ExLocale exLocale = this.localeParser.parse(locale);
                    exLocaleList.add(exLocale);
                }
                exHttpHeaders.setAcceptLanguageAsLocales(exLocaleList);
            }
            boolean accessControlAllowCredentials = httpHeaders.getAccessControlAllowCredentials();
            exHttpHeaders.setAccessControlAllowCredentials(accessControlAllowCredentials);
            List accessControlAllowHeaders = httpHeaders.getAccessControlAllowHeaders();
            exHttpHeaders.setAccessControlAllowHeaders(accessControlAllowHeaders);
            List accessControlAllowMethods = httpHeaders.getAccessControlAllowMethods();
            ArrayList<ExHttpMethod> exAccessControlAllowMethods = null;
            if (null != accessControlAllowMethods && !accessControlAllowMethods.isEmpty()) {
                exAccessControlAllowMethods = new ArrayList<ExHttpMethod>();
                for (HttpMethod httpMethod : accessControlAllowMethods) {
                    ExHttpMethod exHttpMethod = this.httpMethodParser.parse(httpMethod);
                    exAccessControlAllowMethods.add(exHttpMethod);
                }
            }
            exHttpHeaders.setAccessControlAllowMethods(exAccessControlAllowMethods);
            String accessControlAllowOrigin = httpHeaders.getAccessControlAllowOrigin();
            exHttpHeaders.setAccessControlAllowOrigin(accessControlAllowOrigin);
            List accessControlExposeHeaders = httpHeaders.getAccessControlExposeHeaders();
            exHttpHeaders.setAccessControlExposeHeaders(accessControlExposeHeaders);
            long accessControlMaxAge = httpHeaders.getAccessControlMaxAge();
            exHttpHeaders.setAccessControlMaxAge(accessControlMaxAge);
            List accessControlRequestHeaders = httpHeaders.getAccessControlRequestHeaders();
            exHttpHeaders.setAccessControlRequestHeaders(accessControlRequestHeaders);
            HttpMethod accessControlRequestMethod = httpHeaders.getAccessControlRequestMethod();
            ExHttpMethod exAccessControlRequestMethod = this.httpMethodParser.parse(accessControlRequestMethod);
            exHttpHeaders.setAccessControlRequestMethod(exAccessControlRequestMethod);
            Set allow = httpHeaders.getAllow();
            HashSet<ExHttpMethod> exAllow = null;
            if (null != allow && !allow.isEmpty()) {
                exAllow = new HashSet<ExHttpMethod>();
                for (HttpMethod httpMethod : allow) {
                    ExHttpMethod exHttpMethod = this.httpMethodParser.parse(httpMethod);
                    exAllow.add(exHttpMethod);
                }
            }
            exHttpHeaders.setAllow(exAllow);
            String cacheControl = httpHeaders.getCacheControl();
            exHttpHeaders.setCacheControl(cacheControl);
            List connection = httpHeaders.getConnection();
            exHttpHeaders.setConnection(connection);
            ContentDisposition contentDisposition = httpHeaders.getContentDisposition();
            ExContentDisposition exContentDisposition = this.contentDispositionParser.parse(contentDisposition);
            exHttpHeaders.setContentDisposition(exContentDisposition);
            Locale contentLanguage = httpHeaders.getContentLanguage();
            ExLocale exContentLanguage = this.localeParser.parse(contentLanguage);
            exHttpHeaders.setContentLanguage(exContentLanguage);
            long contentLength = httpHeaders.getContentLength();
            exHttpHeaders.setContentLength(contentLength);
            MediaType contentType = httpHeaders.getContentType();
            ExMediaType exContentType = this.mediaTypeParser.parse(contentType);
            exHttpHeaders.setContentType(exContentType);
            long date = httpHeaders.getDate();
            exHttpHeaders.setDate(date);
            String eTag = httpHeaders.getETag();
            exHttpHeaders.setETag(eTag);
            long expires = httpHeaders.getExpires();
            exHttpHeaders.setExpires(expires);
            InetSocketAddress host = httpHeaders.getHost();
            ExInetSocketAddress exHost = this.inetSocketAddressParser.parse(host);
            exHttpHeaders.setHost(exHost);
            List ifMatch = httpHeaders.getIfMatch();
            exHttpHeaders.setIfMatch(ifMatch);
            long ifModifiedSince = httpHeaders.getIfModifiedSince();
            exHttpHeaders.setIfModifiedSince(ifModifiedSince);
            List ifNoneMatch = httpHeaders.getIfNoneMatch();
            exHttpHeaders.setIfNoneMatch(ifNoneMatch);
            long ifUnmodifiedSince = httpHeaders.getIfUnmodifiedSince();
            exHttpHeaders.setIfUnmodifiedSince(ifUnmodifiedSince);
            long lastModified = httpHeaders.getLastModified();
            exHttpHeaders.setLastModified(lastModified);
            URI location = httpHeaders.getLocation();
            ExURI exLocation = this.uriParser.parse(location);
            exHttpHeaders.setLocation(exLocation);
            String origin = httpHeaders.getOrigin();
            exHttpHeaders.setOrigin(origin);
            String pragma = httpHeaders.getPragma();
            exHttpHeaders.setPragma(pragma);
            List range = httpHeaders.getRange();
            if (null != range && !range.isEmpty()) {
                ArrayList<ExBase> exList = new ArrayList<ExBase>();
                for (HttpRange httpRange : range) {
                    ExBase exBase = this.objectParser.parse(httpRange);
                    exList.add(exBase);
                }
                exHttpHeaders.setRange(exList);
            }
            String upgrade = httpHeaders.getUpgrade();
            exHttpHeaders.setUpgrade(upgrade);
            List vary = httpHeaders.getVary();
            exHttpHeaders.setVary(vary);
        }
        return exHttpHeaders;
    }
}

