/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExEnum;
import open.source.exchange.parser.ClassParser;
import open.source.exchange.parser.ObjectParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnumParser {
    private static final Logger log = LogManager.getLogger(EnumParser.class);
    @Autowired
    private ObjectParser objectParser;
    @Autowired
    private ClassParser classParser;

    public ExEnum parse(Enum<?> enumeration) {
        log.trace("parse -> (enumeration) {}", enumeration);
        ExEnum exEnum = null;
        if (null != enumeration) {
            ExBase exBase = this.objectParser.parse(enumeration);
            exEnum = new ExEnum(exBase);
            Class<?> declaringClass = enumeration.getDeclaringClass();
            Object declaringClassObject = this.classParser.parse(declaringClass);
            exEnum.setDeclaringClass(declaringClass.getName());
            String name = enumeration.name();
            exEnum.setName(name);
            int ordinal = enumeration.ordinal();
            exEnum.setOrdinal(ordinal);
        }
        return exEnum;
    }
}

