/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExDuration;
import open.source.exchange.model.ExTemporalUnit;
import open.source.exchange.parser.ObjectParser;
import open.source.exchange.parser.TemporalUnitParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DurationParser {
    private static final Logger log = LogManager.getLogger(DurationParser.class);
    @Autowired
    private ObjectParser objectParser;
    @Autowired
    private TemporalUnitParser temporalUnitParser;

    private ExDuration parseCore(Duration duration) {
        ExBase exBase = this.objectParser.parse(duration);
        ExDuration exDuration = new ExDuration(exBase);
        long seconds = duration.getSeconds();
        exDuration.setSeconds(seconds);
        int nano = duration.getNano();
        exDuration.setNano(nano);
        List<TemporalUnit> units = duration.getUnits();
        ArrayList<ExTemporalUnit> exUnits = null;
        if (null != units && !units.isEmpty()) {
            exUnits = new ArrayList<ExTemporalUnit>();
            for (TemporalUnit temporalUnit : units) {
                ExTemporalUnit exTemporalUnit = this.temporalUnitParser.parse(temporalUnit);
                exUnits.add(exTemporalUnit);
            }
        }
        exDuration.setUnits(exUnits);
        boolean isNegative = duration.isNegative();
        exDuration.setNegative(isNegative);
        boolean isZero = duration.isZero();
        exDuration.setZero(isZero);
        long toDays = duration.toDays();
        exDuration.setToDays(toDays);
        long toHours = duration.toHours();
        exDuration.setToHours(toHours);
        long toMinutes = duration.toMinutes();
        exDuration.setToMinutes(toMinutes);
        long toMillis = duration.toMillis();
        exDuration.setToMillis(toMillis);
        long toNanos = duration.toNanos();
        exDuration.setToNanos(toNanos);
        return exDuration;
    }

    public ExDuration parse(Duration duration) {
        log.trace("parse -> (duration) {}", (Object)duration);
        ExDuration exDuration = null;
        if (null != duration) {
            Duration negated;
            exDuration = this.parseCore(duration);
            Duration absolute = duration.abs();
            if (null != absolute) {
                ExDuration exAbsolute = this.parseCore(absolute);
                exDuration.setAbsolute(exAbsolute);
            }
            if (null != (negated = duration.negated())) {
                ExDuration exNegated = this.parseCore(negated);
                exDuration.setNegated(exNegated);
            }
        }
        return exDuration;
    }
}

