/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.time.Instant;
import java.util.Date;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExDate;
import open.source.exchange.model.ExInstant;
import open.source.exchange.parser.InstantParser;
import open.source.exchange.parser.ObjectParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DateParser {
    private static final Logger log = LogManager.getLogger(DateParser.class);
    @Autowired
    private ObjectParser objectParser;
    @Autowired
    private InstantParser instantParser;

    public ExDate parse(Date date) {
        log.trace("parse -> (date) {}", (Object)date);
        ExDate exDate = null;
        if (null != date) {
            ExBase exBase = this.objectParser.parse(date);
            exDate = new ExDate(exBase);
            long timestamp = date.getTime();
            exDate.setTimestamp(timestamp);
            String toGMTString = date.toGMTString();
            exDate.setToGMTString(toGMTString);
            int timezoneOffset = date.getTimezoneOffset();
            exDate.setTimezoneOffset(timezoneOffset);
            String toLocaleString = date.toLocaleString();
            exDate.setToLocaleString(toLocaleString);
            int year = date.getYear();
            exDate.setYear(year);
            int month = date.getMonth();
            exDate.setMonth(month);
            int day = date.getDate();
            exDate.setDay(day);
            int weekday = date.getDay();
            exDate.setWeekday(weekday);
            int hour = date.getHours();
            exDate.setHour(hour);
            int minute = date.getMinutes();
            exDate.setMinute(minute);
            int second = date.getSeconds();
            exDate.setSecond(second);
            Instant instant = date.toInstant();
            ExInstant exInstant = this.instantParser.parse(instant);
            exDate.setInstant(exInstant);
        }
        return exDate;
    }
}

